/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.modelchecking.predicates;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.Signature;
import org.bigraphs.framework.core.reactivesystem.ReactiveSystemPredicate;

public class AndPredicate<B extends Bigraph<? extends Signature<?>>>
extends ReactiveSystemPredicate<B> {
    private final List<ReactiveSystemPredicate<B>> predicates = new LinkedList<ReactiveSystemPredicate<B>>();

    public AndPredicate(ReactiveSystemPredicate<B> predicateA, ReactiveSystemPredicate<B> predicateB) {
        this(predicateA, predicateB, false);
    }

    public AndPredicate(ReactiveSystemPredicate<B> predicateA, ReactiveSystemPredicate<B> predicateB, boolean negate) {
        this.predicates.add(predicateA);
        this.predicates.add(predicateB);
        this.negate = negate;
    }

    public AndPredicate(boolean negate, ReactiveSystemPredicate<B> ... predicates) {
        this.negate = negate;
        this.predicates.addAll(Arrays.asList(predicates));
    }

    public AndPredicate(ReactiveSystemPredicate<B> ... predicates) {
        this(false, predicates);
    }

    public B getBigraph() {
        return null;
    }

    public boolean test(B agent) {
        Optional reduce = this.predicates.stream().reduce((bReactiveSystemPredicates, bReactiveSystemPredicates2) -> {
            Predicate bPredicate = bReactiveSystemPredicates.isNegate() ? bReactiveSystemPredicates.negate() : bReactiveSystemPredicates;
            Object bPredicate2 = bReactiveSystemPredicates2.isNegate() ? bReactiveSystemPredicates2.negate() : bReactiveSystemPredicates2;
            return (ReactiveSystemPredicate)bPredicate.and(bPredicate2);
        });
        return reduce.map(bReactiveSystemPredicates -> bReactiveSystemPredicates.test(agent)).orElse(true);
    }
}

