/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.modelchecking.predicates;

import org.bigraphs.framework.converter.jlibbig.JLibBigBigraphDecoder;
import org.bigraphs.framework.converter.jlibbig.JLibBigBigraphEncoder;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.Signature;
import org.bigraphs.framework.core.impl.pure.PureBigraph;
import org.bigraphs.framework.core.reactivesystem.ReactiveSystemPredicate;
import org.bigraphs.framework.simulation.encoding.BigraphCanonicalForm;
import org.bigraphs.framework.simulation.encoding.hash.BigraphHashFunction;

public class BigraphIsoPredicate<B extends Bigraph<? extends Signature<?>>>
extends ReactiveSystemPredicate<B> {
    private final B bigraphToMatch;
    private BigraphCanonicalForm canonicalForm;
    private final String bigraphEncoded;
    private BigraphHashFunction<B> hashFunction;

    private BigraphIsoPredicate(B bigraphToMatch) {
        this(bigraphToMatch, false);
    }

    private BigraphIsoPredicate(B bigraphToMatch, boolean negate) {
        it.uniud.mads.jlibbig.core.std.Bigraph encoded = new JLibBigBigraphEncoder().encode((PureBigraph)bigraphToMatch);
        this.bigraphToMatch = new JLibBigBigraphDecoder().decode(encoded);
        this.negate = negate;
        this.canonicalForm = BigraphCanonicalForm.createInstance();
        this.hashFunction = BigraphHashFunction.get(bigraphToMatch.getClass());
        this.bigraphEncoded = this.canonicalForm.bfcs(this.bigraphToMatch);
    }

    public static <B extends Bigraph<? extends Signature<?>>> BigraphIsoPredicate<B> create(B bigraphToMatch) {
        return new BigraphIsoPredicate<B>(bigraphToMatch);
    }

    public static <B extends Bigraph<? extends Signature<?>>> BigraphIsoPredicate<B> create(B bigraphToMatch, boolean negate) {
        return new BigraphIsoPredicate<B>(bigraphToMatch, negate);
    }

    public B getBigraph() {
        return this.bigraphToMatch;
    }

    public boolean test(B agent) {
        PureBigraph decodedAgent = new JLibBigBigraphDecoder().decode(new JLibBigBigraphEncoder().encode((PureBigraph)agent));
        if (this.hashFunction.hash(decodedAgent) != this.hashFunction.hash(this.bigraphToMatch)) {
            return false;
        }
        String bfcs = this.canonicalForm.bfcs(decodedAgent);
        return this.bigraphEncoded.equals(bfcs);
    }

    public B getBigraphToMatch() {
        return this.bigraphToMatch;
    }
}

