/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.modelchecking.predicates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.Signature;
import org.bigraphs.framework.core.reactivesystem.ReactiveSystemPredicate;

public class PredicateChecker<B extends Bigraph<? extends Signature<?>>> {
    private final List<ReactiveSystemPredicate<B>> predicates;
    private final Map<ReactiveSystemPredicate<B>, Boolean> checked = new ConcurrentHashMap<ReactiveSystemPredicate<B>, Boolean>();

    public PredicateChecker(Collection<ReactiveSystemPredicate<B>> predicates) {
        this.predicates = new ArrayList<ReactiveSystemPredicate<B>>(predicates);
    }

    public synchronized boolean checkAll(B agent) {
        this.checked.clear();
        for (ReactiveSystemPredicate<B> each : this.predicates) {
            if (each.isNegate()) {
                this.checked.put(each, each.negate().test(agent));
                continue;
            }
            this.checked.put(each, each.test(agent));
        }
        return this.checkIfAllChecksAreTrue(this.checked);
    }

    private boolean checkIfAllChecksAreTrue(Map<ReactiveSystemPredicate<B>, Boolean> checks) {
        for (boolean b : checks.values()) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public synchronized Map<ReactiveSystemPredicate<B>, Boolean> getChecked() {
        return this.checked;
    }

    public synchronized List<ReactiveSystemPredicate<B>> getPredicates() {
        return this.predicates;
    }
}

