/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.modelchecking.reactions;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.Signature;
import org.bigraphs.framework.core.reactivesystem.ReactionRule;
import org.bigraphs.framework.simulation.modelchecking.reactions.InOrderReactionRuleSupplier;
import org.bigraphs.framework.simulation.modelchecking.reactions.RandomAgentMatchSupplier;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;

public abstract class AbstractReactionRuleSupplier<B extends Bigraph<? extends Signature<?>>>
implements Supplier<ReactionRule<B>> {
    protected final ImmutableList<ReactionRule<B>> availableRules;

    protected AbstractReactionRuleSupplier(Collection<ReactionRule<B>> availableRules) {
        this.availableRules = Lists.immutable.withAll(availableRules);
    }

    public static <B extends Bigraph<? extends Signature<?>>> InOrderReactionRuleSupplier<B> createInOrder(Collection<ReactionRule<B>> availableRules) {
        return new InOrderReactionRuleSupplier<B>(availableRules);
    }

    public static <B extends Bigraph<? extends Signature<?>>> RandomAgentMatchSupplier<B> createRandom(Collection<B> availableRules) {
        return new RandomAgentMatchSupplier<B>(availableRules);
    }

    public List<ReactionRule<B>> getAvailableRules() {
        return this.availableRules.castToList();
    }
}

