/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.aaproperties.xml.AminoAcidComposition;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;

public class ModifiedAminoAcidCompoundSet
implements CompoundSet<AminoAcidCompound> {
    private final Map<String, AminoAcidCompound> aminoAcidCompoundCache = new HashMap<String, AminoAcidCompound>();

    public ModifiedAminoAcidCompoundSet(List<AminoAcidComposition> aaList, Map<Character, Double> aaSymbol2MolecularWeight) {
        this.aminoAcidCompoundCache.put("-", new AminoAcidCompound(null, "-", "", "", Float.valueOf(0.0f)));
        for (AminoAcidComposition aa : aaList) {
            this.aminoAcidCompoundCache.put(aa.getSymbol(), new AminoAcidCompound(null, aa.getSymbol(), aa.getShorName(), aa.getName(), Float.valueOf(aaSymbol2MolecularWeight.get(Character.valueOf(aa.getSymbol().charAt(0))).floatValue())));
        }
    }

    public int getMaxSingleCompoundStringLength() {
        return 1;
    }

    public boolean isCompoundStringLengthEqual() {
        return true;
    }

    public AminoAcidCompound getCompoundForString(String string) {
        if (string.length() == 0) {
            return null;
        }
        if (string.length() > this.getMaxSingleCompoundStringLength()) {
            throw new IllegalArgumentException("String supplied (" + string + ") is too long. Max is " + this.getMaxSingleCompoundStringLength());
        }
        return this.aminoAcidCompoundCache.get(string);
    }

    public String getStringForCompound(AminoAcidCompound compound) {
        return compound.toString();
    }

    public boolean compoundsEquivalent(AminoAcidCompound compoundOne, AminoAcidCompound compoundTwo) {
        return false;
    }

    public Set<AminoAcidCompound> getEquivalentCompounds(AminoAcidCompound compound) {
        return null;
    }

    public boolean hasCompound(AminoAcidCompound compound) {
        return this.aminoAcidCompoundCache.containsValue(compound);
    }

    public List<AminoAcidCompound> getAllCompounds() {
        return new ArrayList<AminoAcidCompound>(this.aminoAcidCompoundCache.values());
    }

    public boolean isComplementable() {
        return false;
    }

    public boolean isValidSequence(Sequence<AminoAcidCompound> sequence) {
        for (AminoAcidCompound c : sequence) {
            if (this.hasCompound(c)) continue;
            return false;
        }
        return true;
    }
}

