/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.aaproperties.Constraints;
import org.biojava.nbio.aaproperties.PeptideProperties;
import org.biojava.nbio.aaproperties.PeptidePropertiesImpl;
import org.biojava.nbio.aaproperties.Utils;
import org.biojava.nbio.aaproperties.xml.AminoAcidCompositionTable;
import org.biojava.nbio.aaproperties.xml.CaseFreeAminoAcidCompoundSet;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.io.FastaReader;
import org.biojava.nbio.core.sequence.io.GenbankReader;
import org.biojava.nbio.core.sequence.io.GenericFastaHeaderParser;
import org.biojava.nbio.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava.nbio.core.sequence.io.ProteinSequenceCreator;
import org.biojava.nbio.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.sequence.template.CompoundSet;

public class CommandPrompt {
    public static void main(String[] args) throws Exception {
        CommandPrompt.run(args);
    }

    private static AminoAcidCompositionTable checkForValidityAndObtainAATable(String inputLocation, int propertyListSize, String aminoAcidCompositionLocation, String elementMassLocation) throws Exception {
        if (inputLocation == null) {
            CommandPrompt.showHelp();
            throw new Error("Please do provide location of input file.");
        }
        if (propertyListSize == 0) {
            CommandPrompt.showHelp();
            throw new Error("Please at least specify a property to compute.");
        }
        AminoAcidCompositionTable aaTable = null;
        if (aminoAcidCompositionLocation != null && elementMassLocation == null) {
            aaTable = PeptideProperties.obtainAminoAcidCompositionTable(new File(aminoAcidCompositionLocation));
        } else if (aminoAcidCompositionLocation != null && elementMassLocation != null) {
            aaTable = PeptideProperties.obtainAminoAcidCompositionTable(new File(aminoAcidCompositionLocation, elementMassLocation));
        } else if (aminoAcidCompositionLocation == null && elementMassLocation != null) {
            throw new Error("You have define the location of Element Mass XML file. Please also define the location of Amino Acid Composition XML file");
        }
        return aaTable;
    }

    private static void readInputAndGenerateOutput(String outputLocation, List<Character> propertyList, List<Character> specificList, String delimiter, String inputLocation, AminoAcidCompositionTable aaTable, int decimalPlace) throws Exception {
        PrintStream output = outputLocation != null ? new PrintStream(new File(outputLocation)) : System.out;
        CommandPrompt.printHeader(output, propertyList, specificList, delimiter);
        LinkedHashMap<String, ProteinSequence> a = CommandPrompt.readInputFile(inputLocation, aaTable);
        for (Map.Entry<String, ProteinSequence> entry : a.entrySet()) {
            CommandPrompt.compute(output, entry.getValue().getOriginalHeader(), entry.getValue().getSequenceAsString().trim(), delimiter, aaTable, propertyList, specificList, decimalPlace);
        }
        output.close();
    }

    public static void run(String[] args) throws Exception {
        ArrayList<Character> propertyList = new ArrayList<Character>();
        ArrayList<Character> specificList = new ArrayList<Character>();
        String inputLocation = null;
        String outputLocation = null;
        String aminoAcidCompositionLocation = null;
        String elementMassLocation = null;
        String delimiter = ",";
        int decimalPlace = 4;
        block19: for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-' || args[i].length() != 2) {
                CommandPrompt.showHelp();
                throw new Error("Unknown option: " + args[i]);
            }
            switch (args[i].charAt(1)) {
                case 'i': {
                    inputLocation = args[++i];
                    continue block19;
                }
                case 'o': {
                    outputLocation = args[++i];
                    continue block19;
                }
                case 'f': {
                    if (args[++i].equalsIgnoreCase("csv")) {
                        delimiter = ",";
                        continue block19;
                    }
                    if (args[i].equalsIgnoreCase("tsv")) {
                        delimiter = "\t";
                        continue block19;
                    }
                    throw new Error("Invalid value for -f: " + args[i] + ". Please choose either csv or tsv only.");
                }
                case 'x': {
                    aminoAcidCompositionLocation = args[++i];
                    continue block19;
                }
                case 'y': {
                    elementMassLocation = args[++i];
                    continue block19;
                }
                case 'd': {
                    decimalPlace = Integer.parseInt(args[++i]);
                    continue block19;
                }
                case 'a': {
                    propertyList.add(Character.valueOf('1'));
                    propertyList.add(Character.valueOf('2'));
                    propertyList.add(Character.valueOf('3'));
                    propertyList.add(Character.valueOf('4'));
                    propertyList.add(Character.valueOf('5'));
                    propertyList.add(Character.valueOf('6'));
                    propertyList.add(Character.valueOf('7'));
                    propertyList.add(Character.valueOf('8'));
                    propertyList.add(Character.valueOf('9'));
                    continue block19;
                }
                case '1': {
                    propertyList.add(Character.valueOf('1'));
                    continue block19;
                }
                case '2': {
                    propertyList.add(Character.valueOf('2'));
                    continue block19;
                }
                case '3': {
                    propertyList.add(Character.valueOf('3'));
                    continue block19;
                }
                case '4': {
                    propertyList.add(Character.valueOf('4'));
                    continue block19;
                }
                case '5': {
                    propertyList.add(Character.valueOf('5'));
                    continue block19;
                }
                case '6': {
                    propertyList.add(Character.valueOf('6'));
                    continue block19;
                }
                case '7': {
                    propertyList.add(Character.valueOf('7'));
                    continue block19;
                }
                case '8': {
                    propertyList.add(Character.valueOf('8'));
                    continue block19;
                }
                case '9': {
                    propertyList.add(Character.valueOf('9'));
                    continue block19;
                }
                case '0': {
                    propertyList.add(Character.valueOf('0'));
                    if (args[++i].length() != 1) {
                        throw new Error("Invalid value: " + args[i] + ". Amino Acid Symbol should be of single character");
                    }
                    specificList.add(Character.valueOf(args[i].toUpperCase().charAt(0)));
                    continue block19;
                }
                default: {
                    CommandPrompt.showHelp();
                    throw new Error("Unknown option: " + args[i]);
                }
            }
        }
        AminoAcidCompositionTable aaTable = CommandPrompt.checkForValidityAndObtainAATable(inputLocation, propertyList.size(), aminoAcidCompositionLocation, elementMassLocation);
        CommandPrompt.readInputAndGenerateOutput(outputLocation, propertyList, specificList, delimiter, inputLocation, aaTable, decimalPlace);
    }

    private static LinkedHashMap<String, ProteinSequence> readInputFile(String inputLocation, AminoAcidCompositionTable aaTable) throws Exception {
        LinkedHashMap ret;
        FileInputStream inStream = new FileInputStream(inputLocation);
        Object set = aaTable == null ? CaseFreeAminoAcidCompoundSet.getAminoAcidCompoundSet() : aaTable.getAminoAcidCompoundSet();
        if (inputLocation.toLowerCase().contains(".gb")) {
            GenbankReader genbankReader = new GenbankReader((InputStream)inStream, (SequenceHeaderParserInterface)new GenericGenbankHeaderParser(), (SequenceCreatorInterface)new ProteinSequenceCreator((CompoundSet)set));
            ret = genbankReader.process();
        } else {
            FastaReader fastaReader = new FastaReader((InputStream)inStream, (SequenceHeaderParserInterface)new GenericFastaHeaderParser(), (SequenceCreatorInterface)new ProteinSequenceCreator((CompoundSet)set));
            ret = fastaReader.process();
        }
        return ret;
    }

    private static void printHeader(PrintStream output, List<Character> propertyList, List<Character> specificList, String delimiter) throws IOException {
        int specificCount = 0;
        ArrayList<String> sList = new ArrayList<String>();
        sList.add("SequenceName");
        for (Character c : propertyList) {
            switch (c.charValue()) {
                case '1': {
                    sList.add(PropertyName.MolecularWeight.toString());
                    break;
                }
                case '2': {
                    sList.add(PropertyName.Absorbance_True.toString());
                    sList.add(PropertyName.Absorbance_False.toString());
                    break;
                }
                case '3': {
                    sList.add(PropertyName.ExtinctionCoefficient_True.toString());
                    sList.add(PropertyName.ExtinctionCoefficient_False.toString());
                    break;
                }
                case '4': {
                    sList.add(PropertyName.InstabilityIndex.toString());
                    break;
                }
                case '5': {
                    sList.add(PropertyName.ApliphaticIndex.toString());
                    break;
                }
                case '6': {
                    sList.add(PropertyName.AverageHydropathyValue.toString());
                    break;
                }
                case '7': {
                    sList.add(PropertyName.IsoelectricPoint.toString());
                    break;
                }
                case '8': {
                    sList.add(PropertyName.NetCharge_pH_7.toString());
                    break;
                }
                case '9': {
                    sList.add(PropertyName.A.toString());
                    sList.add(PropertyName.R.toString());
                    sList.add(PropertyName.N.toString());
                    sList.add(PropertyName.D.toString());
                    sList.add(PropertyName.C.toString());
                    sList.add(PropertyName.E.toString());
                    sList.add(PropertyName.Q.toString());
                    sList.add(PropertyName.G.toString());
                    sList.add(PropertyName.H.toString());
                    sList.add(PropertyName.I.toString());
                    sList.add(PropertyName.L.toString());
                    sList.add(PropertyName.K.toString());
                    sList.add(PropertyName.M.toString());
                    sList.add(PropertyName.F.toString());
                    sList.add(PropertyName.P.toString());
                    sList.add(PropertyName.S.toString());
                    sList.add(PropertyName.T.toString());
                    sList.add(PropertyName.W.toString());
                    sList.add(PropertyName.Y.toString());
                    sList.add(PropertyName.V.toString());
                    break;
                }
                case '0': {
                    sList.add("" + specificList.get(specificCount++));
                }
            }
        }
        for (int i = 0; i < sList.size(); ++i) {
            if (i != 0) {
                output.print(delimiter);
            }
            output.print((String)sList.get(i));
        }
        output.println();
        output.flush();
    }

    private static void compute(PrintStream output, String header, String sequence, String delimiter, AminoAcidCompositionTable aaTable, List<Character> propertyList, List<Character> specificList, int decimalPlace) throws CompoundNotFoundException {
        Object aaSet;
        ProteinSequence pSequence;
        if (aaTable != null) {
            sequence = Utils.checkSequence(sequence, aaTable.getSymbolSet());
            pSequence = new ProteinSequence(sequence, (CompoundSet)aaTable.getAminoAcidCompoundSet());
            aaSet = aaTable.getAminoAcidCompoundSet();
        } else {
            sequence = Utils.checkSequence(sequence);
            pSequence = new ProteinSequence(sequence);
            aaSet = AminoAcidCompoundSet.getAminoAcidCompoundSet();
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        int specificCount = 0;
        ArrayList<Double> dList = new ArrayList<Double>();
        for (Character c : propertyList) {
            switch (c.charValue()) {
                case '1': {
                    if (aaTable == null) {
                        dList.add(pp.getMolecularWeight(pSequence));
                        break;
                    }
                    dList.add(pp.getMolecularWeight(pSequence));
                    break;
                }
                case '2': {
                    dList.add(pp.getAbsorbance(pSequence, true));
                    dList.add(pp.getAbsorbance(pSequence, false));
                    break;
                }
                case '3': {
                    dList.add(pp.getExtinctionCoefficient(pSequence, true));
                    dList.add(pp.getExtinctionCoefficient(pSequence, false));
                    break;
                }
                case '4': {
                    dList.add(pp.getInstabilityIndex(pSequence));
                    break;
                }
                case '5': {
                    dList.add(pp.getApliphaticIndex(pSequence));
                    break;
                }
                case '6': {
                    dList.add(pp.getAvgHydropathy(pSequence));
                    break;
                }
                case '7': {
                    dList.add(pp.getIsoelectricPoint(pSequence));
                    break;
                }
                case '8': {
                    dList.add(pp.getNetCharge(pSequence));
                    break;
                }
                case '9': {
                    Map<AminoAcidCompound, Double> aaCompound2Double = pp.getAAComposition(pSequence);
                    dList.add(aaCompound2Double.get(Constraints.A));
                    dList.add(aaCompound2Double.get(Constraints.R));
                    dList.add(aaCompound2Double.get(Constraints.N));
                    dList.add(aaCompound2Double.get(Constraints.D));
                    dList.add(aaCompound2Double.get(Constraints.C));
                    dList.add(aaCompound2Double.get(Constraints.E));
                    dList.add(aaCompound2Double.get(Constraints.Q));
                    dList.add(aaCompound2Double.get(Constraints.G));
                    dList.add(aaCompound2Double.get(Constraints.H));
                    dList.add(aaCompound2Double.get(Constraints.I));
                    dList.add(aaCompound2Double.get(Constraints.L));
                    dList.add(aaCompound2Double.get(Constraints.K));
                    dList.add(aaCompound2Double.get(Constraints.M));
                    dList.add(aaCompound2Double.get(Constraints.F));
                    dList.add(aaCompound2Double.get(Constraints.P));
                    dList.add(aaCompound2Double.get(Constraints.S));
                    dList.add(aaCompound2Double.get(Constraints.T));
                    dList.add(aaCompound2Double.get(Constraints.W));
                    dList.add(aaCompound2Double.get(Constraints.Y));
                    dList.add(aaCompound2Double.get(Constraints.V));
                    break;
                }
                case '0': {
                    dList.add(pp.getEnrichment(pSequence, (AminoAcidCompound)aaSet.getCompoundForString("" + specificList.get(specificCount++))));
                }
            }
        }
        output.print(header.replace(delimiter, "_"));
        for (int i = 0; i < dList.size(); ++i) {
            output.print(delimiter + Utils.roundToDecimals((Double)dList.get(i), decimalPlace));
        }
        output.println();
        output.flush();
    }

    private static void showHelp() {
        System.err.println("NAME");
        System.err.println("\tAn executable to generate physico-chemical properties of protein sequences.");
        System.err.println();
        System.err.println("EXAMPLES");
        System.err.println("\tjava -jar AAProperties.jar -i test.fasta -a");
        System.err.println("\t\tGenerates all possible properties.");
        System.err.println();
        System.err.println("\tjava -jar AAProperties.jar -i test.fasta -1 -3 -7");
        System.err.println("\t\tGenerates only molecular weight, extinction coefficient and isoelectric point.");
        System.err.println();
        System.err.println("\tjava -jar AAProperties.jar -i test.fasta -0 A -0 N -1");
        System.err.println("\t\tGenerates composition of two specific amino acid symbol and molecular weight.");
        System.err.println();
        System.err.println("OPTIONS");
        System.err.println("\tRequired");
        System.err.println("\t\t-i location of input FASTA file");
        System.err.println();
        System.err.println("\tOptional");
        System.err.println("\t\t-o location of output file [standard output (default)]");
        System.err.println("\t\t-f output format [csv (default) or tsv]");
        System.err.println("\t\t-x location of Amino Acid Composition XML file for defining amino acid composition");
        System.err.println("\t\t-y location of Element Mass XML file for defining mass of elements");
        System.err.println("\t\t-d number of decimals (int) [4 (default)]");
        System.err.println();
        System.err.println("\tProvide at least one of them");
        System.err.println("\t\t-a compute properties of option 1-9");
        System.err.println("\t\t-1 compute molecular weight");
        System.err.println("\t\t-2 compute absorbance");
        System.err.println("\t\t-3 compute extinction coefficient");
        System.err.println("\t\t-4 compute instability index");
        System.err.println("\t\t-5 compute apliphatic index");
        System.err.println("\t\t-6 compute average hydropathy value");
        System.err.println("\t\t-7 compute isoelectric point");
        System.err.println("\t\t-8 compute net charge at pH 7");
        System.err.println("\t\t-9 compute composition of 20 standard amino acid (A, R, N, D, C, E, Q, G, H, I, L, K, M, F, P, S, T, W, Y, V)");
        System.err.println("\t\t-0 compute composition of specific amino acid symbol");
        System.err.println();
    }

    public static enum PropertyName {
        MolecularWeight,
        Absorbance_True,
        Absorbance_False,
        ExtinctionCoefficient_True,
        ExtinctionCoefficient_False,
        InstabilityIndex,
        ApliphaticIndex,
        AverageHydropathyValue,
        IsoelectricPoint,
        NetCharge_pH_7,
        A,
        R,
        N,
        D,
        C,
        E,
        Q,
        G,
        H,
        I,
        L,
        K,
        M,
        F,
        P,
        S,
        T,
        W,
        Y,
        V;

    }
}

