/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.biojava.nbio.aaproperties.xml.Isotope;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Element {
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="symbol")
    private String symbol;
    @XmlAttribute(name="atomicnumber")
    private int atomicNumber;
    @XmlAttribute(name="mass", required=true)
    private double mass;
    @XmlElement
    private List<Isotope> isotope;
    private Map<String, Isotope> name2Isotope;

    public Element() {
    }

    public Element(String name, String symbol, int atomicNumber, List<Isotope> isotopes, double mass) {
        if (atomicNumber <= 0) {
            throw new Error("Atomic number of Elements must be > 0.");
        }
        if (mass <= 0.0) {
            throw new Error("Mass of Elements must be > 0.");
        }
        this.setName(name);
        this.setSymbol(symbol);
        this.setAtomicNumber(atomicNumber);
        this.setIsotopes(isotopes);
        this.setMass(mass);
    }

    public String toString() {
        return this.symbol + ", " + this.name + ", " + this.atomicNumber;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public double getMass() {
        return this.mass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setAtomicNumber(int atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    public List<Isotope> getIsotopes() {
        return this.isotope;
    }

    public void setIsotopes(List<Isotope> isotopes) {
        this.isotope = isotopes;
        this.name2Isotope = new HashMap<String, Isotope>();
        if (isotopes != null) {
            for (Isotope i : isotopes) {
                this.name2Isotope.put(i.getName(), i);
            }
        }
    }
}

