/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties;

import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.biojava.nbio.aaproperties.AminoAcidProperties;
import org.biojava.nbio.aaproperties.PeptidePropertiesImpl;
import org.biojava.nbio.aaproperties.Utils;
import org.biojava.nbio.aaproperties.xml.AminoAcidCompositionTable;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeptideProperties {
    private static final Logger logger = LoggerFactory.getLogger(PeptideProperties.class);
    public static Set<Character> standardAASet = Arrays.stream(SingleLetterAACode.values()).map(singleLetterAACode -> Character.valueOf(singleLetterAACode.toString().charAt(0))).collect(Collectors.toCollection(HashSet::new));

    public static final double getMolecularWeight(String sequence) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getMolecularWeight(pSequence);
    }

    public static final double getMolecularWeight(String sequence, File elementMassFile, File aminoAcidCompositionFile) throws FileNotFoundException, JAXBException {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getMolecularWeight(pSequence, elementMassFile, aminoAcidCompositionFile);
    }

    public static final double getMolecularWeight(String sequence, File aminoAcidCompositionFile) throws FileNotFoundException, JAXBException {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getMolecularWeight(pSequence, aminoAcidCompositionFile);
    }

    public static final AminoAcidCompositionTable obtainAminoAcidCompositionTable(File aminoAcidCompositionFile) throws JAXBException, FileNotFoundException {
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.obtainAminoAcidCompositionTable(aminoAcidCompositionFile);
    }

    public static final AminoAcidCompositionTable obtainAminoAcidCompositionTable(File elementMassFile, File aminoAcidCompositionFile) throws JAXBException, FileNotFoundException {
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.obtainAminoAcidCompositionTable(elementMassFile, aminoAcidCompositionFile);
    }

    public static double getMolecularWeightBasedOnXML(String sequence, AminoAcidCompositionTable aminoAcidCompositionTable) {
        sequence = Utils.checkSequence(sequence, aminoAcidCompositionTable.getSymbolSet());
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence, (CompoundSet)aminoAcidCompositionTable.getAminoAcidCompoundSet());
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getMolecularWeightBasedOnXML(pSequence, aminoAcidCompositionTable);
    }

    public static final double getAbsorbance(String sequence, boolean assumeCysReduced) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getAbsorbance(pSequence, assumeCysReduced);
    }

    public static final double getExtinctionCoefficient(String sequence, boolean assumeCysReduced) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getExtinctionCoefficient(pSequence, assumeCysReduced);
    }

    public static final double getInstabilityIndex(String sequence) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getInstabilityIndex(pSequence);
    }

    public static final double getApliphaticIndex(String sequence) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getApliphaticIndex(pSequence);
    }

    public static final double getAvgHydropathy(String sequence) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getAvgHydropathy(pSequence);
    }

    public static final double getIsoelectricPoint(String sequence, boolean useExpasyValues) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getIsoelectricPoint(pSequence, useExpasyValues);
    }

    public static final double getIsoelectricPoint(String sequence) {
        return PeptideProperties.getIsoelectricPoint(sequence, true);
    }

    public static final double getNetCharge(String sequence, boolean useExpasyValues, double pHPoint) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getNetCharge(pSequence, useExpasyValues, pHPoint);
    }

    public static final double getNetCharge(String sequence, boolean useExpasyValues) {
        return PeptideProperties.getNetCharge(sequence, useExpasyValues, 7.0);
    }

    public static final double getNetCharge(String sequence) {
        return PeptideProperties.getNetCharge(sequence, true);
    }

    public static final double getEnrichment(String sequence, SingleLetterAACode aminoAcidCode) {
        return PeptideProperties.getEnrichment(sequence, aminoAcidCode.toString());
    }

    public static final double getEnrichment(String sequence, char aminoAcidCode) {
        return PeptideProperties.getEnrichment(sequence, aminoAcidCode);
    }

    public static final double getEnrichment(String sequence, String aminoAcidCode) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        return pp.getEnrichment(pSequence, aaSet.getCompoundForString(aminoAcidCode));
    }

    public static final Map<AminoAcidCompound, Double> getAAComposition(String sequence) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getAAComposition(pSequence);
    }

    public static final Map<String, Double> getAACompositionString(String sequence) {
        Map<AminoAcidCompound, Double> aa2Composition = PeptideProperties.getAAComposition(sequence);
        HashMap<String, Double> aaString2Composition = new HashMap();
        aaString2Composition = aa2Composition.keySet().stream().collect(Collectors.toMap(aaCompound -> aaCompound.getShortName(), aaCompound -> (Double)aa2Composition.get(aaCompound)));
        return aaString2Composition;
    }

    public static final Map<Character, Double> getAACompositionChar(String sequence) {
        Map<AminoAcidCompound, Double> aa2Composition = PeptideProperties.getAAComposition(sequence);
        HashMap<Character, Double> aaChar2Composition = new HashMap<Character, Double>();
        for (AminoAcidCompound aaCompound : aa2Composition.keySet()) {
            aaChar2Composition.put(Character.valueOf(aaCompound.getShortName().charAt(0)), aa2Composition.get(aaCompound));
        }
        return aaChar2Composition;
    }

    public static final int[] getChargesOfAminoAcids(String sequence) {
        int[] charges = new int[sequence.length()];
        for (int i = 0; i < sequence.length(); ++i) {
            char aa = sequence.toCharArray()[i];
            charges[i] = AminoAcidProperties.getChargeOfAminoAcid(aa);
        }
        return charges;
    }

    public static final int[] getPolarityOfAminoAcids(String sequence) {
        int[] polarity = new int[sequence.length()];
        for (int i = 0; i < sequence.length(); ++i) {
            char aa = sequence.toCharArray()[i];
            polarity[i] = AminoAcidProperties.getPolarityOfAminoAcid(aa);
        }
        return polarity;
    }

    public static final double getAromaticity(String sequence) {
        sequence = Utils.checkSequence(sequence);
        ProteinSequence pSequence = null;
        try {
            pSequence = new ProteinSequence(sequence);
        }
        catch (CompoundNotFoundException e) {
            logger.error("The protein sequence contains invalid characters ({}), this should not happen. This is most likely a bug in Utils.checkSequence()", (Object)e.getMessage());
        }
        PeptidePropertiesImpl pp = new PeptidePropertiesImpl();
        return pp.getAromaticity(pSequence);
    }

    public static enum SingleLetterAACode {
        W,
        C,
        M,
        H,
        Y,
        F,
        Q,
        N,
        I,
        R,
        D,
        P,
        T,
        K,
        E,
        V,
        S,
        G,
        A,
        L;

    }
}

