/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties;

import java.nio.CharBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.nbio.aaproperties.PeptideProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static final double roundToDecimals(double d, int c) {
        if (c < 0) {
            return d;
        }
        double p = Math.pow(10.0, c);
        double tmp = Math.round(d *= p);
        return tmp / p;
    }

    public static final boolean doesSequenceContainInvalidChar(String sequence, Set<Character> cSet) {
        for (char c : sequence.toCharArray()) {
            if (cSet.contains(Character.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    public static final int getNumberOfInvalidChar(String sequence, Set<Character> cSet, boolean ignoreCase) {
        char[] cArray = ignoreCase ? sequence.toUpperCase().toCharArray() : sequence.toCharArray();
        Set<Character> characterSet = cSet == null ? PeptideProperties.standardAASet : cSet;
        int total = (int)CharBuffer.wrap(cArray).chars().filter(character -> !characterSet.contains(Character.valueOf((char)character))).count();
        return total;
    }

    public static final String cleanSequence(String sequence, Set<Character> cSet) {
        HashSet<Character> invalidCharSet = new HashSet<Character>();
        StringBuilder cleanSeq = new StringBuilder();
        if (cSet == null) {
            cSet = PeptideProperties.standardAASet;
        }
        for (char c : sequence.toCharArray()) {
            if (!cSet.contains(Character.valueOf(c))) {
                cleanSeq.append("-");
                invalidCharSet.add(Character.valueOf(c));
                continue;
            }
            cleanSeq.append(c);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = invalidCharSet.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            stringBuilder.append("'" + c + "'");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(" are being replaced with '-'");
        logger.warn(stringBuilder.toString());
        return cleanSeq.toString();
    }

    public static final String checkSequence(String sequence) {
        return Utils.checkSequence(sequence, null);
    }

    public static final String checkSequence(String sequence, Set<Character> cSet) {
        boolean containInvalid = false;
        if (cSet != null) {
            containInvalid = sequence != null && Utils.doesSequenceContainInvalidChar(sequence, cSet);
        } else {
            boolean bl = containInvalid = sequence != null && Utils.doesSequenceContainInvalidChar(sequence, PeptideProperties.standardAASet);
        }
        if (containInvalid) {
            String cSeq = Utils.cleanSequence(sequence, cSet);
            logger.warn("There exists invalid characters in the sequence. Computed results might not be precise.");
            logger.warn("To remove this warning: Please use org.biojava.nbio.aaproperties.Utils.cleanSequence to clean sequence.");
            return cSeq;
        }
        return sequence;
    }
}

