/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties.profeat;

import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.aaproperties.profeat.IProfeatProperties;
import org.biojava.nbio.aaproperties.profeat.convertor.Convert2Charge;
import org.biojava.nbio.aaproperties.profeat.convertor.Convert2Hydrophobicity;
import org.biojava.nbio.aaproperties.profeat.convertor.Convert2NormalizedVanDerWaalsVolume;
import org.biojava.nbio.aaproperties.profeat.convertor.Convert2Polarity;
import org.biojava.nbio.aaproperties.profeat.convertor.Convert2Polarizability;
import org.biojava.nbio.aaproperties.profeat.convertor.Convert2SecondaryStructure;
import org.biojava.nbio.aaproperties.profeat.convertor.Convert2SolventAccessibility;
import org.biojava.nbio.aaproperties.profeat.convertor.Convertor;
import org.biojava.nbio.core.sequence.ProteinSequence;

public class ProfeatPropertiesImpl
implements IProfeatProperties {
    @Override
    public double getComposition(ProteinSequence sequence, IProfeatProperties.ATTRIBUTE attribute, IProfeatProperties.GROUPING group) throws Exception {
        Convertor convertor = this.getConvertor(attribute);
        String convertedSequence = convertor.convert(sequence);
        return ((double)this.getTotalCount(convertedSequence, group) + 0.0) / (double)convertedSequence.length();
    }

    private int getTotalCount(String convertedSeq, IProfeatProperties.GROUPING group) throws Exception {
        char g;
        switch (group) {
            case GROUP1: {
                g = '1';
                break;
            }
            case GROUP2: {
                g = '2';
                break;
            }
            case GROUP3: {
                g = '3';
                break;
            }
            default: {
                throw new Exception("Unhandled Case: " + group);
            }
        }
        int total = 0;
        total = (int)convertedSeq.chars().filter(c -> (char)c == g).count();
        return total;
    }

    @Override
    public double getTransition(ProteinSequence sequence, IProfeatProperties.ATTRIBUTE attribute, IProfeatProperties.TRANSITION transition) throws Exception {
        char t2;
        char t1;
        Convertor convertor = this.getConvertor(attribute);
        String convertedSequence = convertor.convert(sequence);
        switch (transition) {
            case BETWEEN_11: {
                t1 = '1';
                t2 = '1';
                break;
            }
            case BETWEEN_22: {
                t1 = '2';
                t2 = '2';
                break;
            }
            case BETWEEN_33: {
                t1 = '3';
                t2 = '3';
                break;
            }
            case BETWEEN_12: {
                t1 = '1';
                t2 = '2';
                break;
            }
            case BETWEEN_13: {
                t1 = '1';
                t2 = '3';
                break;
            }
            case BETWEEN_23: {
                t1 = '2';
                t2 = '3';
                break;
            }
            default: {
                throw new Exception("Unhandled Case: " + transition);
            }
        }
        int total = 0;
        for (int i = 0; i < convertedSequence.length() - 1; ++i) {
            char s1 = convertedSequence.charAt(i);
            char s2 = convertedSequence.charAt(i + 1);
            if ((t1 != s1 || t2 != s2) && (t2 != s1 || t1 != s2)) continue;
            ++total;
        }
        return (double)total / ((double)convertedSequence.length() - 1.0);
    }

    @Override
    public double getDistributionPosition(ProteinSequence sequence, IProfeatProperties.ATTRIBUTE attribute, IProfeatProperties.GROUPING group, IProfeatProperties.DISTRIBUTION distribution) throws Exception {
        char g;
        int countIndex;
        Convertor convertor = this.getConvertor(attribute);
        String convertedSequence = convertor.convert(sequence);
        int totalCount = this.getTotalCount(convertedSequence, group);
        switch (distribution) {
            case FIRST: {
                countIndex = 1;
                break;
            }
            case FIRST25: {
                countIndex = totalCount * 25 / 100;
                break;
            }
            case FIRST50: {
                countIndex = totalCount * 50 / 100;
                break;
            }
            case FIRST75: {
                countIndex = totalCount * 75 / 100;
                break;
            }
            case ALL: {
                countIndex = totalCount;
                break;
            }
            default: {
                throw new Exception("Unhandled Case: " + distribution);
            }
        }
        switch (group) {
            case GROUP1: {
                g = '1';
                break;
            }
            case GROUP2: {
                g = '2';
                break;
            }
            case GROUP3: {
                g = '3';
                break;
            }
            default: {
                throw new Exception("Unhandled Case: " + group);
            }
        }
        int currentCount = 0;
        int dist = 0;
        for (int x = 0; x < convertedSequence.length(); ++x) {
            if (g != convertedSequence.charAt(x) || ++currentCount != countIndex) continue;
            dist = x + 1;
            break;
        }
        return ((double)dist + 0.0) / (double)convertedSequence.length();
    }

    private Convertor getConvertor(IProfeatProperties.ATTRIBUTE attribute) throws Exception {
        switch (attribute) {
            case HYDROPHOBICITY: {
                return new Convert2Hydrophobicity();
            }
            case VOLUME: {
                return new Convert2NormalizedVanDerWaalsVolume();
            }
            case POLARITY: {
                return new Convert2Polarity();
            }
            case POLARIZABILITY: {
                return new Convert2Polarizability();
            }
            case CHARGE: {
                return new Convert2Charge();
            }
            case SECONDARYSTRUCTURE: {
                return new Convert2SecondaryStructure();
            }
            case SOLVENTACCESSIBILITY: {
                return new Convert2SolventAccessibility();
            }
        }
        throw new Exception("Unknown attribute: " + attribute);
    }

    @Override
    public Map<IProfeatProperties.GROUPING, Double> getComposition(ProteinSequence sequence, IProfeatProperties.ATTRIBUTE attribute) throws Exception {
        HashMap<IProfeatProperties.GROUPING, Double> grouping2Composition = new HashMap<IProfeatProperties.GROUPING, Double>();
        for (IProfeatProperties.GROUPING group : IProfeatProperties.GROUPING.values()) {
            grouping2Composition.put(group, this.getComposition(sequence, attribute, group));
        }
        return grouping2Composition;
    }

    @Override
    public Map<IProfeatProperties.ATTRIBUTE, Map<IProfeatProperties.GROUPING, Double>> getComposition(ProteinSequence sequence) throws Exception {
        HashMap<IProfeatProperties.ATTRIBUTE, Map<IProfeatProperties.GROUPING, Double>> attribute2Grouping2Composition = new HashMap<IProfeatProperties.ATTRIBUTE, Map<IProfeatProperties.GROUPING, Double>>();
        for (IProfeatProperties.ATTRIBUTE attribute : IProfeatProperties.ATTRIBUTE.values()) {
            attribute2Grouping2Composition.put(attribute, this.getComposition(sequence, attribute));
        }
        return attribute2Grouping2Composition;
    }

    @Override
    public Map<IProfeatProperties.TRANSITION, Double> getTransition(ProteinSequence sequence, IProfeatProperties.ATTRIBUTE attribute) throws Exception {
        HashMap<IProfeatProperties.TRANSITION, Double> transition2Double = new HashMap<IProfeatProperties.TRANSITION, Double>();
        for (IProfeatProperties.TRANSITION transition : IProfeatProperties.TRANSITION.values()) {
            transition2Double.put(transition, this.getTransition(sequence, attribute, transition));
        }
        return transition2Double;
    }

    @Override
    public Map<IProfeatProperties.ATTRIBUTE, Map<IProfeatProperties.TRANSITION, Double>> getTransition(ProteinSequence sequence) throws Exception {
        HashMap<IProfeatProperties.ATTRIBUTE, Map<IProfeatProperties.TRANSITION, Double>> attribute2Transition2Double = new HashMap<IProfeatProperties.ATTRIBUTE, Map<IProfeatProperties.TRANSITION, Double>>();
        for (IProfeatProperties.ATTRIBUTE attribute : IProfeatProperties.ATTRIBUTE.values()) {
            attribute2Transition2Double.put(attribute, this.getTransition(sequence, attribute));
        }
        return attribute2Transition2Double;
    }

    @Override
    public Map<IProfeatProperties.DISTRIBUTION, Double> getDistributionPosition(ProteinSequence sequence, IProfeatProperties.ATTRIBUTE attribute, IProfeatProperties.GROUPING group) throws Exception {
        HashMap<IProfeatProperties.DISTRIBUTION, Double> distribution2Double = new HashMap<IProfeatProperties.DISTRIBUTION, Double>();
        for (IProfeatProperties.DISTRIBUTION distribution : IProfeatProperties.DISTRIBUTION.values()) {
            distribution2Double.put(distribution, this.getDistributionPosition(sequence, attribute, group, distribution));
        }
        return distribution2Double;
    }

    @Override
    public Map<IProfeatProperties.GROUPING, Map<IProfeatProperties.DISTRIBUTION, Double>> getDistributionPosition(ProteinSequence sequence, IProfeatProperties.ATTRIBUTE attribute) throws Exception {
        HashMap<IProfeatProperties.GROUPING, Map<IProfeatProperties.DISTRIBUTION, Double>> grouping2Distribution2Double = new HashMap<IProfeatProperties.GROUPING, Map<IProfeatProperties.DISTRIBUTION, Double>>();
        for (IProfeatProperties.GROUPING group : IProfeatProperties.GROUPING.values()) {
            grouping2Distribution2Double.put(group, this.getDistributionPosition(sequence, attribute, group));
        }
        return grouping2Distribution2Double;
    }

    @Override
    public Map<IProfeatProperties.ATTRIBUTE, Map<IProfeatProperties.GROUPING, Map<IProfeatProperties.DISTRIBUTION, Double>>> getDistributionPosition(ProteinSequence sequence) throws Exception {
        HashMap<IProfeatProperties.ATTRIBUTE, Map<IProfeatProperties.GROUPING, Map<IProfeatProperties.DISTRIBUTION, Double>>> attribute2Grouping2Distribution2Double = new HashMap<IProfeatProperties.ATTRIBUTE, Map<IProfeatProperties.GROUPING, Map<IProfeatProperties.DISTRIBUTION, Double>>>();
        for (IProfeatProperties.ATTRIBUTE attribute : IProfeatProperties.ATTRIBUTE.values()) {
            attribute2Grouping2Distribution2Double.put(attribute, this.getDistributionPosition(sequence, attribute));
        }
        return attribute2Grouping2Distribution2Double;
    }
}

