/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.Chart;
import com.approximatrix.charting.Legend;
import com.approximatrix.charting.Title;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.AbstractRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChart
extends AbstractRenderer
implements Chart {
    protected static final int MISSING_LEGEND_WIDTH = 30;
    protected static final int MISSING_TITLE_HEIGHT = 20;
    protected HashMap<Integer, AbstractChartRenderer> renderer = new HashMap();
    protected Rectangle bounds;
    protected Legend legend;
    protected CoordSystem coord;
    protected Title title;
    protected RowColorModel rcModel;
    protected ChartDataModel model;

    @Override
    public void addChartRenderer(AbstractChartRenderer abstractChartRenderer, int n) {
        this.renderer.put(new Integer(n), abstractChartRenderer);
        abstractChartRenderer.setRowColorModel(this.rcModel);
    }

    @Override
    public Map<Integer, AbstractChartRenderer> getChartRenderer() {
        return this.renderer;
    }

    @Override
    public AbstractChartRenderer getChartRenderer(int n) {
        return this.renderer.get(new Integer(n));
    }

    @Override
    public CoordSystem getCoordSystem() {
        return this.coord;
    }

    @Override
    public Legend getLegend() {
        return this.legend;
    }

    @Override
    public Title getTitle() {
        return this.title;
    }

    public RowColorModel getRowColorModel() {
        return this.rcModel;
    }

    public void setChartRenderer(Map map) {
        Iterator iterator = map.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.addChartRenderer((AbstractChartRenderer)iterator.next(), n);
        }
    }

    @Override
    public void setCoordSystem(CoordSystem coordSystem) {
        this.coord = coordSystem;
    }

    @Override
    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    @Override
    public void setTitle(Title title) {
        this.title = title;
    }

    public void setRowColorModel(RowColorModel rowColorModel) throws NullPointerException {
        if (rowColorModel == null) {
            throw new NullPointerException();
        }
        for (AbstractChartRenderer abstractChartRenderer : this.getChartRenderer().values()) {
            if (abstractChartRenderer == null || abstractChartRenderer.getRowColorModel() != this.rcModel) continue;
            abstractChartRenderer.setRowColorModel(rowColorModel);
        }
        if (this.getLegend() != null && this.getLegend().getRowColorModel() == this.rcModel) {
            this.getLegend().setRowColorModel(rowColorModel);
        }
        this.rcModel = rowColorModel;
    }

    @Override
    public void setChartDataModel(ChartDataModel chartDataModel) {
        this.model = chartDataModel;
    }

    @Override
    public ChartDataModel getChartDataModel() {
        return this.model;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void paintDefault(Graphics2D graphics2D) {
    }

    @Override
    public void render(Graphics2D graphics2D) {
    }
}

