/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.model.ChartDataModelConstraints;

public class Axis {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int LOGARITHMIC = 3;
    public static final int LINEAR = 4;
    private int align = 1;
    ChartDataModelConstraints constraints;
    int length = Integer.MAX_VALUE;

    public Axis(int n, ChartDataModelConstraints chartDataModelConstraints) {
        if (n == 1 || n == 2) {
            this.align = n;
        }
        this.constraints = chartDataModelConstraints;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int getLength() {
        return this.length;
    }

    public double getPixelForValue(double d) {
        try {
            double d2 = this.getPointToPixelRatio();
            if (d2 != 0.0) {
                if (this.getAlignment() == 2) {
                    return (d - this.constraints.getMinimumY().doubleValue()) / d2;
                }
                return (d - this.constraints.getMinimumX().doubleValue()) / d2;
            }
            return 0.0;
        }
        catch (NullPointerException nullPointerException) {
            return 0.0;
        }
    }

    public double getPointToPixelRatio() {
        try {
            if (this.getAlignment() == 2) {
                return (this.constraints.getMaximumY().doubleValue() - this.constraints.getMinimumY().doubleValue()) / (double)this.length;
            }
            return (this.constraints.getMaximumX().doubleValue() - this.constraints.getMinimumX().doubleValue()) / (double)this.length;
        }
        catch (NullPointerException nullPointerException) {
            if ((double)this.length != 0.0) {
                return 1.0 / (double)this.length;
            }
            return 0.0;
        }
    }
}

