/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.AbstractChart;
import com.approximatrix.charting.Legend;
import com.approximatrix.charting.Title;
import com.approximatrix.charting.coordsystem.ClassicCoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystemUtilities;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.Renderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class BufferedChart
extends AbstractChart
implements RenderChangeListener,
ChartDataModelListener {
    public static int LINEAR_X_LINEAR_Y = 0;
    public static int NO_COORDINATE_SYSTEM = 1;
    private static final Class DEFAULT_COORDSYS = ClassicCoordSystem.class;
    private static final boolean DEBUG_CHART = false;
    protected String render_message = "Rendering...";
    protected Font font = new Font("Helvetica", 0, 22);
    private RenderThread rt = null;
    private BufferedImage buffer = null;
    private BufferedImage drawbuffer = null;
    private boolean redraw = true;
    private boolean enableBuffering = true;

    protected BufferedChart() {
    }

    public BufferedChart(ChartDataModel chartDataModel, String string) {
        this();
        this.setChartDataModel(chartDataModel);
        this.setRowColorModel(new RowColorModel(chartDataModel));
        this.setLegend(new Legend(this.getRowColorModel()));
        this.setTitle(new Title(string));
        this.initialize();
    }

    public BufferedChart(ChartDataModel chartDataModel, String string, int n) {
        this(chartDataModel, string);
        if (n == LINEAR_X_LINEAR_Y) {
            this.setCoordSystem(CoordSystemUtilities.BuildDefaultCoordSystem(chartDataModel));
        }
        this.initialize();
    }

    public BufferedChart(ChartDataModel chartDataModel, String string, int n, String string2, String string3) {
        this(chartDataModel, string, n);
        this.getCoordSystem().setXAxisUnit(string2);
        this.getCoordSystem().setYAxisUnit(string3);
        this.initialize();
    }

    private void initialize() {
        this.assignListeners();
        this.setBounds(new Rectangle(1, 1));
        this.initBuffer();
    }

    private void assignListeners() {
        ArrayList<Renderer> arrayList = new ArrayList<Renderer>();
        arrayList.add(this.legend);
        arrayList.add(this.coord);
        arrayList.add(this.title);
        Collection<AbstractChartRenderer> collection = this.getChartRenderer().values();
        arrayList.addAll(collection);
        for (Renderer renderer : arrayList) {
            if (renderer == null) continue;
            renderer.addRenderChangeListener(this);
        }
        for (AbstractChartRenderer abstractChartRenderer : collection) {
            if (abstractChartRenderer == null || abstractChartRenderer.getChartDataModel() == null) continue;
            abstractChartRenderer.getChartDataModel().addChartDataModelListener(this);
        }
    }

    public Dimension getPreferredSize() {
        return null;
    }

    private void initBuffer() {
        this.buffer = this.createBuffer();
        this.drawNotification();
    }

    private BufferedImage createBuffer() {
        int n = 1;
        int n2 = 1;
        if (this.getBounds() != null) {
            n = (int)this.getBounds().getWidth();
            n2 = (int)this.getBounds().getHeight();
        }
        return new BufferedImage(n, n2, 1);
    }

    private boolean invalidBuffer() {
        if (this.buffer == null) {
            return true;
        }
        if (this.getBounds() == null) {
            return true;
        }
        return this.buffer.getWidth() != (int)this.getBounds().getWidth() || this.buffer.getHeight() != (int)this.getBounds().getHeight();
    }

    public void setBuffering(boolean bl) {
        this.enableBuffering = bl;
    }

    public boolean isBuffering() {
        return this.enableBuffering;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getRenderMessage() {
        return this.render_message;
    }

    public void setRenderMessage(String string) {
        if (string != null) {
            this.render_message = string;
        }
    }

    public void notifyDisplayReady(boolean bl) {
        if (bl) {
            this.buffer = this.drawbuffer;
            this.drawbuffer = null;
        } else {
            this.redraw = true;
        }
        this.fireRenderChangeEvent();
    }

    public void render(Graphics2D graphics2D) {
        if (this.invalidBuffer()) {
            this.initBuffer();
            this.redraw = true;
        }
        if (this.enableBuffering) {
            if (this.redraw) {
                this.drawbuffer = this.createBuffer();
                if (this.rt != null) {
                    if (this.rt.isAlive()) {
                        this.rt.stopRender();
                        try {
                            this.rt.join();
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println("Rendering Thread Join Failed!");
                            interruptedException.printStackTrace();
                        }
                    }
                    this.rt = null;
                }
                this.rt = new RenderThread(this.drawbuffer, this);
                this.rt.start();
            }
            this.redraw = false;
            this.drawBufferImage(graphics2D);
        } else {
            this.drawChart(graphics2D);
        }
    }

    private void drawNotification() {
        Graphics2D graphics2D = this.buffer.createGraphics();
        int n = (int)this.getBounds().getWidth();
        int n2 = (int)this.getBounds().getHeight();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.gray);
        TextLayout textLayout = new TextLayout(this.getRenderMessage(), this.getFont(), new FontRenderContext(null, true, false));
        Rectangle2D rectangle2D = textLayout.getBounds();
        textLayout.draw(graphics2D, (float)(((double)n - rectangle2D.getWidth()) / 2.0), (float)(((double)n2 - rectangle2D.getHeight()) / 2.0));
    }

    private void drawBufferImage(Graphics2D graphics2D) {
        graphics2D.drawImage((Image)this.buffer, 0, 0, null);
    }

    public void drawChart(Graphics2D graphics2D) {
        Object object;
        int n = (int)this.getBounds().getWidth();
        int n2 = (int)this.getBounds().getHeight();
        Title title = this.getTitle();
        Legend legend = this.getLegend();
        CoordSystem coordSystem = this.getCoordSystem();
        Collection<AbstractChartRenderer> collection = this.getChartRenderer().values();
        for (AbstractChartRenderer abstractChartRenderer : collection) {
            abstractChartRenderer.resetStopFlag();
        }
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.black);
        int n3 = 20;
        int n4 = 30;
        if (title != null) {
            object = title.getPreferredSize();
            title.setBounds(new Rectangle(n / 2 - (int)(((Dimension)object).getWidth() / 2.0), 0, (int)((Dimension)object).getWidth(), (int)((Dimension)object).getHeight()));
            title.render(graphics2D);
            n3 = (int)title.getBounds().getHeight();
        }
        if (legend != null) {
            object = legend.getPreferredSize();
            legend.setBounds(new Rectangle((int)((double)n - ((Dimension)object).getWidth()), (int)((double)(n2 / 2) - ((Dimension)object).getHeight() / 2.0 + (double)n3), (int)((Dimension)object).getWidth(), (int)((Dimension)object).getHeight()));
            legend.render(graphics2D);
            n4 = (int)legend.getBounds().getWidth();
        }
        if (coordSystem != null) {
            coordSystem.setBounds(new Rectangle(0, n3, n - n4, n2 - n3));
        }
        for (AbstractChartRenderer abstractChartRenderer : collection) {
            abstractChartRenderer.setBounds(coordSystem.getInnerBounds());
            abstractChartRenderer.render(graphics2D);
        }
        if (coordSystem != null) {
            coordSystem.render(graphics2D);
        }
    }

    public void renderUpdateRequested(RenderChangeEvent renderChangeEvent) {
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    public void chartDataChanged(ChartDataModelEvent chartDataModelEvent) {
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    public void addChartRenderer(AbstractChartRenderer abstractChartRenderer, int n) {
        super.addChartRenderer(abstractChartRenderer, n);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    public void setChartRenderer(Map map) {
        super.setChartRenderer(map);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    public void setCoordSystem(CoordSystem coordSystem) {
        super.setCoordSystem(coordSystem);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    public void setLegend(Legend legend) {
        super.setLegend(legend);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    public void setTitle(Title title) {
        super.setTitle(title);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    public void setRowColorModel(RowColorModel rowColorModel) {
        super.setRowColorModel(rowColorModel);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    public void setChartDataModel(ChartDataModel chartDataModel) {
        super.setChartDataModel(chartDataModel);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    private class RenderThread
    extends Thread {
        private volatile boolean renderingStoppped = false;
        private BufferedImage bi = null;
        private BufferedChart parent = null;

        public RenderThread(BufferedImage bufferedImage, BufferedChart bufferedChart2) {
            this.bi = bufferedImage;
            this.parent = bufferedChart2;
        }

        public void run() {
            if (this.bi != null) {
                Graphics2D graphics2D = this.bi.createGraphics();
                this.parent.drawChart(graphics2D);
                if (!this.renderingStoppped) {
                    this.parent.notifyDisplayReady(true);
                }
            } else {
                this.parent.notifyDisplayReady(false);
            }
        }

        public void stopRender() {
            Collection<AbstractChartRenderer> collection = this.parent.getChartRenderer().values();
            for (AbstractChartRenderer abstractChartRenderer : collection) {
                abstractChartRenderer.interruptRendering();
            }
            this.renderingStoppped = true;
        }
    }
}

