/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.Chart;
import com.approximatrix.charting.EncodingException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ChartEncoder {
    public static void createJPEG(OutputStream outputStream, Chart chart) throws EncodingException {
        boolean bl = true;
        try {
            Rectangle rectangle = chart.getBounds();
            BufferedImage bufferedImage = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            chart.render(graphics2D);
            bl = ImageIO.write((RenderedImage)bufferedImage, "jpeg", outputStream);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            throw new EncodingException(throwable.getMessage(), throwable);
        }
        if (!bl) {
            throw new EncodingException("No ImageWriter for writing JPEGs found.");
        }
    }

    public static void createGIF(OutputStream outputStream, Chart chart) throws EncodingException {
    }

    public static void createPNG(OutputStream outputStream, Chart chart) throws EncodingException {
        boolean bl = true;
        try {
            Rectangle rectangle = chart.getBounds();
            BufferedImage bufferedImage = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            chart.render(graphics2D);
            bl = ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new EncodingException(throwable.getMessage(), throwable);
        }
        if (!bl) {
            throw new EncodingException("No ImageWriter for writing PNGs found.");
        }
    }

    public static void createEncodedImage(OutputStream outputStream, Chart chart, String string) throws EncodingException {
        boolean bl = true;
        try {
            Rectangle rectangle = chart.getBounds();
            BufferedImage bufferedImage = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            chart.render(graphics2D);
            bl = ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            throw new EncodingException(throwable.getMessage(), throwable);
        }
        if (!bl) {
            throw new EncodingException("No ImageWriter for writing " + string + " images found.");
        }
    }

    public static String[] getSupportedFormats() {
        return ImageIO.getWriterFormatNames();
    }
}

