/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import java.util.Arrays;
import java.util.TreeSet;

public class ChartUtilities {
    public static double[] performAutoScale(double d, double d2) {
        double[] dArray = new double[2];
        double d3 = d2 - d;
        dArray[0] = ChartUtilities.floor(d, ChartUtilities.exp(d3));
        dArray[1] = ChartUtilities.ceil(d2, ChartUtilities.exp(d3));
        return dArray;
    }

    public static double calculateTickSpacing(double d, double d2) {
        double d3 = 1.0;
        double d4 = d2 - d;
        int n = ChartUtilities.exp(d4);
        if (d4 / (d3 = 1.0 * Math.pow(10.0, --n)) < 20.0) {
            return 0.5 * d3;
        }
        if (d4 / d3 > 40.0) {
            return 2.0 * d3;
        }
        return d3;
    }

    public static double interpolate(double[] dArray, double[] dArray2, double d) {
        int n;
        if (dArray.length != dArray2.length || dArray.length == 0 || dArray2.length == 0) {
            System.out.println("** Invalid Parameter");
            return Double.NaN;
        }
        int n2 = dArray.length;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 1;
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double d4 = Math.abs(d - dArray[0]);
        for (n = 0; n < n2; ++n) {
            double d5;
            double d6 = Math.abs(d - dArray[n]);
            if (d5 < d4) {
                n3 = n;
                d4 = d6;
            }
            dArray3[n] = dArray2[n];
            dArray4[n] = dArray2[n];
        }
        d2 = dArray2[n3--];
        for (int i = 0; i < n2 - 1; ++i) {
            for (n = 0; n < n2 - i - 1; ++n) {
                double d7 = dArray[n] - d;
                double d8 = dArray[n + i + 1] - d;
                double d9 = dArray3[n + 1] - dArray4[n];
                double d10 = d7 - d8;
                if (d10 == 0.0) {
                    return Double.NaN;
                }
                d10 = d9 / d10;
                dArray4[n] = d8 * d10;
                dArray3[n] = d7 * d10;
            }
            d3 = 2 * (n3 + 1) < n2 - i ? dArray3[n3 + 1] : dArray4[n3--];
            d2 += d3;
        }
        return d2;
    }

    public static double floor(double d, int n) {
        double d2 = 1.0 * Math.pow(10.0, n);
        return Math.floor(d / d2) * d2;
    }

    public static double ceil(double d, int n) {
        double d2 = 1.0 * Math.pow(10.0, n);
        return Math.ceil(d / d2) * d2;
    }

    public static int exp(double d) {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = d <= -1.0 || d >= 1.0;
        while (d <= -10.0 || d >= 10.0 || d > -1.0 && d < 1.0) {
            if (bl) {
                d /= 10.0;
                ++n;
                continue;
            }
            d *= 10.0;
            --n;
        }
        return n;
    }

    public static Number[][] transformArray(int[][] nArray) {
        Number[][] numberArray = new Number[nArray.length][nArray[0].length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                numberArray[i][j] = new Integer(nArray[i][j]);
            }
        }
        return numberArray;
    }

    public static Number[][] transformArray(double[][] dArray) {
        Number[][] numberArray = new Number[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                numberArray[i][j] = new Double(dArray[i][j]);
            }
        }
        return numberArray;
    }

    public static Number[] transformArray(double[] dArray) {
        Number[] numberArray = new Number[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            numberArray[i] = new Double(dArray[i]);
        }
        return numberArray;
    }

    public static Number[] transformArray(int[] nArray) {
        Number[] numberArray = new Number[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            numberArray[i] = new Integer(nArray[i]);
        }
        return numberArray;
    }

    public static void addDataToSet(TreeSet treeSet, Number[][] numberArray) {
        for (int i = 0; i < numberArray.length; ++i) {
            treeSet.addAll(Arrays.asList(numberArray[i]));
        }
    }

    public static void main(String[] stringArray) {
        double d = -0.00337;
        double d2 = 0.00745;
        double[] dArray = ChartUtilities.performAutoScale(d, d2);
        System.out.println("** AutoScaling: (" + d + ", " + d2 + ") -> (" + dArray[0] + ", " + dArray[1] + ")");
        double d3 = ChartUtilities.calculateTickSpacing(dArray[0], dArray[1]);
        System.out.print("** Ticks: ");
        for (double d4 = dArray[0]; d4 <= dArray[1]; d4 += d3) {
            System.out.print(" " + d4 + " ");
        }
        System.out.println();
        System.out.println("** Performing interpolation for 4*x^2");
        System.out.println("** Given values [-4, 64], [0, 0], [3, 36]");
        double[] dArray2 = new double[]{-4.0, 0.0, 3.0};
        double[] dArray3 = new double[]{64.0, 0.0, 36.0};
        System.out.print("** Calculating values");
        for (double d5 = -5.0; d5 < 6.0; d5 += 0.5) {
            System.out.print("[" + d5 + ", " + ChartUtilities.interpolate(dArray2, dArray3, d5) + "]");
        }
        System.out.println();
        System.out.println("** Performing interpolation for 5 * x^3 - 4 * x^2 + 2 * x - 5");
        System.out.println("** Given values [-5, -740], [0, -5], [1, -2], [5, 530]");
        double[] dArray4 = new double[]{-5.0, 0.0, 1.0, 5.0};
        double[] dArray5 = new double[]{-740.0, -5.0, -2.0, 530.0};
        System.out.print("** Calculating values ");
        for (double d6 = -5.0; d6 < 6.0; d6 += 0.5) {
            System.out.print("[" + d6 + ", " + ChartUtilities.interpolate(dArray4, dArray5, d6) + "]");
        }
        System.out.println();
    }
}

