/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.AbstractChart;
import com.approximatrix.charting.Legend;
import com.approximatrix.charting.Title;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystemUtilities;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;

public class ExtendedChart
extends AbstractChart {
    public static final int LINEAR_X_LINEAR_Y = 0;
    public static final int NO_COORDINATE_SYSTEM = 1;

    protected ExtendedChart() {
    }

    public ExtendedChart(ChartDataModel chartDataModel, String string) {
        this();
        this.setChartDataModel(chartDataModel);
        this.setRowColorModel(new RowColorModel(chartDataModel));
        this.setLegend(new Legend(this.getRowColorModel()));
        this.setTitle(new Title(string));
    }

    public ExtendedChart(ChartDataModel chartDataModel, String string, int n) {
        this(chartDataModel, string);
        if (n == 0) {
            this.setCoordSystem(CoordSystemUtilities.BuildDefaultCoordSystem(chartDataModel));
        }
    }

    public ExtendedChart(ChartDataModel chartDataModel, String string, int n, String string2, String string3) {
        this(chartDataModel, string, n);
        this.getCoordSystem().setXAxisUnit(string2);
        this.getCoordSystem().setYAxisUnit(string3);
    }

    public Dimension getPreferredSize() {
        return null;
    }

    public void render(Graphics2D graphics2D) {
        Object object;
        int n = (int)this.getBounds().getWidth();
        int n2 = (int)this.getBounds().getHeight();
        Title title = this.getTitle();
        Legend legend = this.getLegend();
        CoordSystem coordSystem = this.getCoordSystem();
        Collection<AbstractChartRenderer> collection = this.getChartRenderer().values();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.black);
        int n3 = 20;
        int n4 = 30;
        if (title != null) {
            object = title.getPreferredSize();
            title.setBounds(new Rectangle(n / 2 - (int)(((Dimension)object).getWidth() / 2.0), 0, (int)((Dimension)object).getWidth(), (int)((Dimension)object).getHeight()));
            title.render(graphics2D);
            n3 = (int)title.getBounds().getHeight();
        }
        if (legend != null) {
            object = legend.getPreferredSize();
            legend.setBounds(new Rectangle((int)((double)n - ((Dimension)object).getWidth()), (int)((double)(n2 / 2) - ((Dimension)object).getHeight() / 2.0 + (double)n3), (int)((Dimension)object).getWidth(), (int)((Dimension)object).getHeight()));
            legend.render(graphics2D);
            n4 = (int)legend.getBounds().getWidth();
        }
        if (coordSystem != null) {
            coordSystem.setBounds(new Rectangle(0, n3, n - n4, n2 - n3));
        }
        if (!collection.isEmpty()) {
            for (AbstractChartRenderer abstractChartRenderer : collection) {
                abstractChartRenderer.setBounds(coordSystem.getInnerBounds());
                abstractChartRenderer.render(graphics2D);
            }
        }
        if (coordSystem != null) {
            coordSystem.render(graphics2D);
        }
    }

    public void zoom(Rectangle rectangle) {
        double[] dArray = new double[]{rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        if (rectangle.width == 0 || (double)rectangle.height == 0.0) {
            return;
        }
        Collection<AbstractChartRenderer> collection = this.getChartRenderer().values();
        if (!collection.isEmpty()) {
            for (AbstractChartRenderer abstractChartRenderer : collection) {
                AffineTransform affineTransform = abstractChartRenderer.getTransform(0);
                try {
                    affineTransform.inverseTransform(dArray, 0, dArray2, 0, 2);
                    ChartDataModel chartDataModel = abstractChartRenderer.getChartDataModel();
                    chartDataModel.setMaximumValueX(new Double(dArray2[2]));
                    chartDataModel.setMinimumValueX(new Double(dArray2[0]));
                    chartDataModel.setMaximumValueY(new Double(dArray2[1]));
                    chartDataModel.setMinimumValueY(new Double(dArray2[3]));
                    chartDataModel.fireChartDataModelChangedEvent(this);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {}
            }
        }
    }
}

