/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.render.AbstractRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;

public class Legend
extends AbstractRenderer {
    protected int inner_margin = 5;
    protected int color_text_spacing = 10;
    protected Font font = new Font("Helvetica", 0, 14);
    protected Rectangle colorbox = new Rectangle(25, 15);
    protected RowColorModel rcm;

    public Legend() {
    }

    public Legend(RowColorModel rowColorModel) {
        this.setRowColorModel(rowColorModel);
    }

    public void setRowColorModel(RowColorModel rowColorModel) {
        this.rcm = rowColorModel;
        super.fireRenderChangeEvent();
    }

    public RowColorModel getRowColorModel() {
        return this.rcm;
    }

    public void setColorBox(Rectangle rectangle) {
        this.colorbox = rectangle;
        super.fireRenderChangeEvent();
    }

    public Rectangle getColorBox() {
        return this.colorbox;
    }

    public void setFont(Font font) {
        this.font = font;
        super.fireRenderChangeEvent();
    }

    public Font getFont() {
        return this.font;
    }

    public Dimension getPreferredSize() {
        RowColorModel rowColorModel = this.getRowColorModel();
        int n = 0;
        int n2 = 0;
        n2 = (int)this.getFont().getMaxCharBounds(new FontRenderContext(null, true, false)).getHeight();
        for (int i = 0; i < rowColorModel.getRowCount(); ++i) {
            TextLayout textLayout = new TextLayout(rowColorModel.getRow(i), this.getFont(), new FontRenderContext(null, true, false));
            n = (int)Math.max((double)n, textLayout.getBounds().getWidth());
        }
        return new Dimension((int)((double)(2 * this.inner_margin + this.color_text_spacing) + this.getColorBox().getWidth() + (double)n), Math.max(n2, (int)this.getColorBox().getHeight()) * rowColorModel.getRowCount() + (rowColorModel.getRowCount() + 1) * this.inner_margin);
    }

    public void paintDefault(Graphics2D graphics2D) {
        RowColorModel rowColorModel = this.getRowColorModel();
        int n = Integer.MIN_VALUE;
        int n2 = (int)this.getFont().getMaxCharBounds(graphics2D.getFontRenderContext()).getHeight();
        n = (int)Math.max((double)n2, this.getColorBox().getHeight());
        int n3 = this.inner_margin;
        int n4 = this.inner_margin;
        Rectangle rectangle = this.getColorBox();
        for (int i = 0; i < rowColorModel.getRowCount(); ++i) {
            rectangle.setLocation(n3, n4);
            graphics2D.setColor(rowColorModel.getColor(i));
            graphics2D.fill(rectangle);
            graphics2D.setColor(Color.black);
            TextLayout textLayout = new TextLayout(rowColorModel.getRow(i), this.getFont(), new FontRenderContext(null, true, false));
            textLayout.draw(graphics2D, n3 + (int)rectangle.getWidth() + this.color_text_spacing, n4 + (int)rectangle.getHeight());
            n4 = n4 + n + this.inner_margin;
        }
    }
}

