/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import java.awt.BasicStroke;

public class SimpleStrokeDefs {
    private static final float[][] dash = new float[][]{{1.0f, 0.0f}, {2.0f, 2.0f}, {7.0f, 7.0f}, {4.0f, 4.0f}, {4.0f, 4.0f, 2.0f, 4.0f}};
    private static final int NUMBER_OF_STYLES = 5;
    public static final BasicStroke SOLID = new BasicStroke(1.0f, 0, 0, 10.0f, dash[0], 0.0f);
    private static final String SOLID_NAME = "Solid Line";
    public static final BasicStroke DOT = new BasicStroke(1.0f, 0, 0, 10.0f, dash[1], 0.0f);
    private static final String DOT_NAME = "Dotted Line";
    public static final BasicStroke LARGE_DASH = new BasicStroke(1.0f, 0, 0, 10.0f, dash[2], 0.0f);
    private static final String LARGE_DASH_NAME = "Large-Dashed Line";
    public static final BasicStroke SMALL_DASH = new BasicStroke(1.0f, 0, 0, 10.0f, dash[3], 0.0f);
    private static final String SMALL_DASH_NAME = "Small-Dashed Line";
    public static final BasicStroke DASH_DOT = new BasicStroke(1.0f, 0, 0, 10.0f, dash[3], 0.0f);
    private static final String DASH_DOT_NAME = "Dash-Dot Line";

    public static String getStrokeDescription(BasicStroke basicStroke) {
        if (basicStroke == SOLID) {
            return SOLID_NAME;
        }
        if (basicStroke == DOT) {
            return DOT_NAME;
        }
        if (basicStroke == LARGE_DASH) {
            return LARGE_DASH_NAME;
        }
        if (basicStroke == SMALL_DASH) {
            return SMALL_DASH_NAME;
        }
        if (basicStroke == DASH_DOT) {
            return DASH_DOT_NAME;
        }
        return "Unknown";
    }

    public static BasicStroke getStroke(String string) {
        if (string == SOLID_NAME) {
            return SOLID;
        }
        if (string == DOT_NAME) {
            return DOT;
        }
        if (string == LARGE_DASH_NAME) {
            return LARGE_DASH;
        }
        if (string == SMALL_DASH_NAME) {
            return SMALL_DASH;
        }
        if (string == DASH_DOT_NAME) {
            return DASH_DOT;
        }
        return SOLID;
    }

    public static String getDefaultStrokeDescription() {
        return SOLID_NAME;
    }

    public static String[] getAvailableStyles() {
        String[] stringArray = new String[]{SOLID_NAME, DOT_NAME, LARGE_DASH_NAME, SMALL_DASH_NAME, DASH_DOT_NAME};
        return stringArray;
    }
}

