/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.render.AbstractRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class Title
extends AbstractRenderer {
    protected String text = "Chart Title";
    protected Font font = new Font("Helvetica", 0, 22);

    public Title() {
    }

    public Title(String string) {
        this.setText(string);
    }

    public Title(String string, Font font) {
        this.setText(string);
        this.setFont(font);
    }

    public void setText(String string) {
        this.text = string;
        super.fireRenderChangeEvent();
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        this.font = font;
        super.fireRenderChangeEvent();
    }

    public Font getFont() {
        return this.font;
    }

    public void paintDefault(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        TextLayout textLayout = new TextLayout(this.getText(), this.getFont(), new FontRenderContext(null, true, false));
        textLayout.draw(graphics2D, 0.0f, (float)this.getPreferredSize().getHeight() - textLayout.getDescent());
    }

    public Dimension getPreferredSize() {
        Rectangle2D rectangle2D = this.getFont().getStringBounds(this.getText(), new FontRenderContext(null, true, false));
        return new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }
}

