/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem;

import com.approximatrix.charting.Axis;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.render.AbstractRenderer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import javax.swing.event.EventListenerList;

public abstract class AbstractCoordSystem
extends AbstractRenderer
implements CoordSystem {
    protected EventListenerList listener = new EventListenerList();
    protected String xaxis_unit = "x";
    protected String yaxis_unit = "y";
    protected DecimalFormat dfY;
    protected DecimalFormat dfX;
    protected Font tickFont = new Font("sans", 0, 10);
    protected Font unitFont = new Font("sans", 0, 10);
    protected Axis xaxis;
    protected Axis yaxis;
    protected Axis yaxis2;
    protected int leftmargin = 75;
    protected int topmargin = 20;
    protected int rightmargin = 30;
    protected int bottommargin = 30;
    protected boolean shouldPaintOnlyTick = true;
    protected boolean shouldPaintLabels = true;
    protected boolean shouldPaintGrid = false;
    protected boolean shouldPaintAxes = true;
    Rectangle bounds = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected AffineTransform y1transform;
    protected AffineTransform y2transform;
    protected boolean centerObjectLabelsBetweenTicks = true;

    public Font getFont() {
        return this.getTickFont();
    }

    public Font getTickFont() {
        return this.tickFont;
    }

    public Font getUnitFont() {
        return this.unitFont;
    }

    public Axis getXAxis() {
        return this.xaxis;
    }

    public String getXAxisUnit() {
        return this.xaxis_unit;
    }

    public DecimalFormat getXDecimalFormat() {
        return this.dfX;
    }

    public String getYAxisUnit() {
        return this.yaxis_unit;
    }

    public DecimalFormat getYDecimalFormat() {
        return this.dfY;
    }

    public abstract void paintDefault(Graphics2D var1);

    public void render(Graphics2D graphics2D) {
        this.paintDefault(graphics2D);
    }

    public void setFont(Font font) {
        this.setTickFont(font);
    }

    public void setTickFont(Font font) {
        this.tickFont = font;
    }

    public void setUnitFont(Font font) {
        this.unitFont = font;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Dimension getPreferredSize() {
        return new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void setBounds(Rectangle rectangle) {
        if (!this.isDifferentBounds(rectangle)) {
            return;
        }
        this.bounds = rectangle;
        this.setRightMargin(this.computeRightMargin());
        this.setLeftMargin(this.computeLeftMargin());
        this.setTopMargin(this.computeTopMargin());
        this.setBottomMargin(this.computeBottomMargin());
        this.xaxis.setLength((int)rectangle.getWidth() - this.getLeftMargin() - this.getRightMargin());
        this.yaxis.setLength((int)rectangle.getHeight() - this.getTopMargin() - this.getBottomMargin());
        if (this.yaxis2 != null) {
            this.yaxis2.setLength((int)rectangle.getHeight() - this.getTopMargin() - this.getBottomMargin());
        }
        this.setTransforms();
        this.fireRenderChangeEvent();
    }

    protected void setTransforms() {
        this.setTransform(this.getDefaultTransform(0), 0);
        if (this.yaxis2 != null) {
            this.setTransform(this.getDefaultTransform(1), 1);
        }
    }

    public boolean isPaintOnlyTick() {
        return this.shouldPaintOnlyTick;
    }

    public boolean isPaintLabels() {
        return this.shouldPaintLabels;
    }

    public boolean isPaintGrid() {
        return this.shouldPaintGrid;
    }

    public void setPaintGrid(boolean bl) {
        this.shouldPaintGrid = bl;
        this.fireRenderChangeEvent();
    }

    public boolean getPaintGrid() {
        return this.shouldPaintGrid;
    }

    public void setPaintLabels(boolean bl) {
        this.shouldPaintLabels = bl;
        this.fireRenderChangeEvent();
    }

    public boolean isPaintAxes() {
        return this.shouldPaintAxes;
    }

    public void setPaintAxes(boolean bl) {
        this.shouldPaintAxes = bl;
        this.fireRenderChangeEvent();
    }

    public void setXAxis(Axis axis) {
        this.xaxis = axis;
    }

    public void setFirstYAxis(Axis axis) {
        this.yaxis = axis;
    }

    public Axis getFirstYAxis() {
        return this.yaxis;
    }

    public void setSecondYAxis(Axis axis) {
        this.yaxis2 = axis;
    }

    public Axis getSecondYAxis() {
        return this.yaxis2;
    }

    public void setXAxisUnit(String string) {
        this.xaxis_unit = string;
        this.fireRenderChangeEvent();
    }

    public void setYAxisUnit(String string) {
        this.yaxis_unit = string;
        this.fireRenderChangeEvent();
    }

    public void setXDecimalFormat(DecimalFormat decimalFormat) {
        this.dfX = decimalFormat;
        this.fireRenderChangeEvent();
    }

    public void setYDecimalFormat(DecimalFormat decimalFormat) {
        this.dfY = decimalFormat;
        this.fireRenderChangeEvent();
    }

    public void fireRenderChangeEvent() {
        RenderChangeEvent renderChangeEvent = new RenderChangeEvent(this);
        Object[] objectArray = this.listener.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RenderChangeListener.class) continue;
            ((RenderChangeListener)objectArray[i + 1]).renderUpdateRequested(renderChangeEvent);
        }
    }

    public void removeRenderChangeListener(RenderChangeListener renderChangeListener) {
        this.listener.remove(RenderChangeListener.class, renderChangeListener);
    }

    public void addRenderChangeListener(RenderChangeListener renderChangeListener) {
        Object[] objectArray = this.listener.getListenerList();
        boolean bl = false;
        for (int i = objectArray.length - 1; i >= 1; i -= 2) {
            if (objectArray[i] != renderChangeListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.listener.add(RenderChangeListener.class, renderChangeListener);
        }
    }

    public void clearRenderChangeListeners() {
        this.listener = new EventListenerList();
    }

    protected int getLeftMargin() {
        return this.leftmargin;
    }

    protected int getRightMargin() {
        return this.rightmargin;
    }

    protected int getTopMargin() {
        return this.topmargin;
    }

    protected int getBottomMargin() {
        return this.bottommargin;
    }

    protected void setLeftMargin(int n) {
        this.leftmargin = n;
    }

    protected void setRightMargin(int n) {
        this.rightmargin = n;
    }

    protected void setTopMargin(int n) {
        this.topmargin = n;
    }

    protected void setBottomMargin(int n) {
        this.bottommargin = n;
    }

    protected abstract int computeLeftMargin();

    protected abstract int computeRightMargin();

    protected abstract int computeTopMargin();

    protected abstract int computeBottomMargin();

    public Rectangle getInnerBounds() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle((int)rectangle.getX() + this.getLeftMargin() - 1, (int)rectangle.getY() + this.getTopMargin() - 1, (int)rectangle.getWidth() - (this.getLeftMargin() + this.getRightMargin()) + 2, (int)rectangle.getHeight() - (this.getTopMargin() + this.getBottomMargin()) + 2);
        return rectangle2;
    }

    public AffineTransform getDefaultTransform(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d = 1.0 / this.getXAxis().getPointToPixelRatio();
        d3 = this.getBounds().getX() + (double)this.getLeftMargin() + this.getXAxis().getPixelForValue(0.0);
        switch (n) {
            case 0: {
                d2 = 1.0 / this.getFirstYAxis().getPointToPixelRatio();
                d4 = this.getBounds().getY() + this.getBounds().getHeight() - (double)this.getBottomMargin() - this.getFirstYAxis().getPixelForValue(0.0);
                break;
            }
            case 1: {
                d2 = 1.0 / this.getSecondYAxis().getPointToPixelRatio();
                d4 = this.getBounds().getY() + this.getBounds().getHeight() - (double)this.getBottomMargin() - this.getSecondYAxis().getPixelForValue(0.0);
            }
        }
        return new AffineTransform(d, 0.0, 0.0, -d2, d3, d4);
    }

    public AffineTransform getTransform(int n) {
        switch (n) {
            case 0: {
                return this.y1transform;
            }
            case 1: {
                return this.y2transform;
            }
        }
        return null;
    }

    public void setTransform(AffineTransform affineTransform, int n) {
        switch (n) {
            case 0: {
                this.y1transform = affineTransform;
                break;
            }
            case 1: {
                this.y2transform = affineTransform;
            }
        }
        super.fireRenderChangeEvent();
    }

    public boolean isCenterLabelsBetweenTicks() {
        return this.centerObjectLabelsBetweenTicks;
    }

    public void setCenterLabelsBetweenTicks(boolean bl) {
        this.centerObjectLabelsBetweenTicks = bl;
    }
}

