/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem;

import com.approximatrix.charting.Axis;
import com.approximatrix.charting.coordsystem.AbstractCoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystemUtilities;
import com.approximatrix.charting.coordsystem.ticklocator.NumericXTickLocator;
import com.approximatrix.charting.coordsystem.ticklocator.NumericYTickLocator;
import com.approximatrix.charting.coordsystem.ticklocator.ObjectXTickLocator;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class BoxCoordSystem
extends AbstractCoordSystem
implements ChartDataModelListener {
    private static final int DEFAULT_MAX_ACTUAL_TICKS = 40;
    protected static final int BOTTOM_BUFFER = 5;
    protected static final int LEFT_BUFFER = 5;
    private static final float[] DOT1 = new float[]{1.0f};
    protected static boolean DRAW_OBJECT_X_AXIS_GRID = false;
    private int estimated_x_ticks = 20;
    private int estimated_y_ticks = 20;
    private int maximum_x_ticks = 40;
    private int maximum_y_ticks = 40;
    private int ticSize = 5;
    protected ChartDataModelConstraints constraints;
    protected ChartDataModelConstraints constraints2;
    protected ChartDataModel model;
    protected Stroke gridStroke = new BasicStroke(1.0f, 0, 0, 10.0f, DOT1, 0.0f);
    protected Color gridColor = Color.lightGray;

    public BoxCoordSystem(ChartDataModel chartDataModel) {
        this.constraints = chartDataModel.getChartDataModelConstraints(0);
        this.constraints2 = chartDataModel.getChartDataModelConstraints(1);
        this.model = chartDataModel;
        this.xaxis = new Axis(1, this.constraints);
        this.yaxis = new Axis(2, this.constraints);
        this.dfY = new DecimalFormat();
        this.dfX = new DecimalFormat();
        chartDataModel.addChartDataModelListener(this);
        this.centerObjectLabelsBetweenTicks = !chartDataModel.isColumnNumeric();
    }

    protected int computeBottomMargin() {
        TextLayout textLayout = new TextLayout(this.getXAxisUnit(), this.getUnitFont(), new FontRenderContext(null, true, false));
        Rectangle2D rectangle2D = new Rectangle();
        if (this.model.isColumnNumeric()) {
            rectangle2D = new TextLayout("1.0", this.getTickFont(), new FontRenderContext(null, true, false)).getBounds();
        } else {
            for (int i = 0; i < this.model.getDataSetNumber(); ++i) {
                for (int j = 0; j < this.model.getDataSetLength(i); ++j) {
                    Rectangle2D rectangle2D2 = this.getTickFont().getStringBounds(this.model.getColumnValueAt(i, j).toString(), new FontRenderContext(null, true, false));
                    if (rectangle2D2.getBounds().height <= rectangle2D.getBounds().height) continue;
                    rectangle2D = rectangle2D2;
                }
            }
        }
        return (int)textLayout.getBounds().getHeight() + (int)rectangle2D.getHeight() + 15;
    }

    protected int computeLeftMargin() {
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        TextLayout textLayout = new TextLayout(this.getYAxisUnit(), this.getUnitFont().deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966)), fontRenderContext);
        TextLayout textLayout2 = new TextLayout("1.0", this.getTickFont().deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966)), fontRenderContext);
        return (int)textLayout.getBounds().getWidth() + (int)textLayout2.getBounds().getWidth() + 15;
    }

    protected int computeRightMargin() {
        return 0;
    }

    protected int computeTopMargin() {
        return 0;
    }

    public void paintDefault(Graphics2D graphics2D) {
        if (!this.shouldPaintAxes) {
            return;
        }
        graphics2D.setColor(Color.black);
        Rectangle rectangle = this.getInnerBounds();
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.shouldPaintGrid) {
            // empty if block
        }
        graphics2D.setColor(Color.black);
        TextLayout textLayout = new TextLayout(this.getXAxisUnit(), this.getUnitFont(), new FontRenderContext(null, true, false));
        textLayout.draw(graphics2D, (float)(rectangle.getCenterX() - textLayout.getBounds().getWidth() / 2.0), (float)(this.getBounds().getMinY() + this.getBounds().getHeight() - 5.0));
        graphics2D.setColor(Color.black);
        TextLayout textLayout2 = new TextLayout(this.getYAxisUnit(), this.getUnitFont().deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966)), new FontRenderContext(null, true, false));
        textLayout2.draw(graphics2D, 5.0f + (float)textLayout2.getBounds().getWidth() / 2.0f, (float)rectangle.y + (float)(rectangle.getCenterY() + textLayout2.getBounds().getWidth() / 2.0));
        this.drawYAxisTicks(graphics2D);
        this.drawXAxisTicks(graphics2D);
    }

    public void chartDataChanged(ChartDataModelEvent chartDataModelEvent) {
        this.setTransforms();
    }

    public ChartDataModelConstraints getChartDataModelConstraints(int n) {
        if (n == 0) {
            return this.constraints;
        }
        if (n == 1) {
            return this.constraints2;
        }
        return null;
    }

    public int getMaximumXTicks() {
        return this.maximum_x_ticks;
    }

    public int getMaximumYTicks() {
        return this.maximum_y_ticks;
    }

    public void resetMaximumXTicks() {
        this.maximum_x_ticks = 40;
    }

    public void resetMaximumYTicks() {
        this.maximum_y_ticks = 40;
    }

    public void setMaximumXTicks(int n) {
        this.maximum_x_ticks = n;
    }

    public void setMaximumYTicks(int n) {
        this.maximum_y_ticks = n;
    }

    private void drawYAxisTicks(Graphics2D graphics2D) {
        double[] dArray = null;
        try {
            dArray = CoordSystemUtilities.SafeMaxMin(this.constraints.getMaximumY().doubleValue(), this.constraints.getMinimumY().doubleValue());
        }
        catch (NullPointerException nullPointerException) {
            dArray[0] = 0.0;
            dArray[1] = 1.0;
        }
        double[] dArray2 = new NumericYTickLocator(dArray[0], dArray[1], this.estimated_y_ticks, 40).getTickMarkLocationsAsPairs(0.0);
        if (dArray2 == null) {
            return;
        }
        double[] dArray3 = new double[dArray2.length];
        this.getTransform(0).transform(dArray2, 0, dArray3, 0, dArray2.length / 2);
        graphics2D.setColor(Color.BLACK);
        int n = this.getInnerBounds().x + this.getInnerBounds().width;
        int n2 = this.getInnerBounds().x;
        Font font = this.getTickFont().deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966));
        for (int i = 1; i < dArray2.length; i += 2) {
            int n3 = (int)Math.round(dArray3[i]);
            if (n3 > this.getInnerBounds().y + this.getInnerBounds().height || n3 < this.getInnerBounds().y) continue;
            graphics2D.drawLine(n, n3, n - this.ticSize, n3);
            graphics2D.drawLine(n2, n3, n2 + this.ticSize, n3);
            if (this.shouldPaintGrid) {
                this.drawSingleGridline(graphics2D, n2 + this.ticSize, n3, n - this.ticSize, n3);
            }
            TextLayout textLayout = new TextLayout(super.getYDecimalFormat().format(dArray2[i]), font, new FontRenderContext(null, true, false));
            textLayout.draw(graphics2D, n2 - 5, n3 + (int)(textLayout.getBounds().getHeight() / 2.0));
        }
    }

    private void drawXAxisTicks(Graphics2D graphics2D) {
        if (this.model.isColumnNumeric()) {
            this.drawNumericalXAxisTicks(graphics2D);
        } else {
            this.drawObjectXAxisTicks(graphics2D);
        }
    }

    private void drawNumericalXAxisTicks(Graphics2D graphics2D) {
        double[] dArray = null;
        try {
            dArray = CoordSystemUtilities.SafeMaxMin(this.constraints.getMaximumX().doubleValue(), this.constraints.getMinimumX().doubleValue());
        }
        catch (NullPointerException nullPointerException) {
            dArray[0] = 0.0;
            dArray[1] = 1.0;
        }
        double[] dArray2 = new NumericXTickLocator(dArray[0], dArray[1], this.estimated_x_ticks, 40).getTickMarkLocationsAsPairs(0.0);
        if (dArray2 == null) {
            return;
        }
        double[] dArray3 = new double[dArray2.length];
        this.getTransform(0).transform(dArray2, 0, dArray3, 0, dArray2.length / 2);
        graphics2D.setColor(Color.BLACK);
        int n = this.getInnerBounds().y + this.getInnerBounds().height;
        int n2 = this.getInnerBounds().y;
        for (int i = 0; i < dArray2.length; i += 2) {
            int n3 = (int)Math.round(dArray3[i]);
            if (n3 > this.getInnerBounds().x + this.getInnerBounds().width || n3 < this.getInnerBounds().x) continue;
            graphics2D.drawLine(n3, n2, n3, n2 + this.ticSize);
            graphics2D.drawLine(n3, n, n3, n - this.ticSize);
            if (this.shouldPaintGrid) {
                this.drawSingleGridline(graphics2D, n3, n2 + this.ticSize, n3, n - this.ticSize);
            }
            TextLayout textLayout = new TextLayout(super.getXDecimalFormat().format(dArray2[i]), this.getTickFont(), new FontRenderContext(null, true, false));
            if (this.isCenterLabelsBetweenTicks()) {
                n3 += (int)((dArray3[i + 2] - (double)n3) / 2.0);
            }
            textLayout.draw(graphics2D, n3 - (int)(textLayout.getBounds().getWidth() / 2.0), n + 5 + (int)textLayout.getBounds().getHeight());
        }
    }

    private void drawObjectXAxisTicks(Graphics2D graphics2D) {
        int n;
        int n2;
        float[] fArray = null;
        try {
            fArray = new ObjectXTickLocator(this.constraints.getMinimumX().intValue(), this.constraints.getMaximumX().intValue(), this.estimated_x_ticks).getTickMarkLocationsAsPairs(0);
        }
        catch (NullPointerException nullPointerException) {
            n2 = 0;
            while (this.model.getColumnValueAt(n2) != null) {
                ++n2;
            }
            fArray = new float[n2 * 2];
            for (n = 0; n < n2; n += 2) {
                fArray[n] = n / 2;
                fArray[n + 1] = 0.0f;
            }
        }
        if (fArray == null) {
            return;
        }
        float[] fArray2 = new float[fArray.length];
        this.getTransform(0).transform(fArray, 0, fArray2, 0, fArray.length / 2);
        graphics2D.setColor(Color.BLACK);
        n2 = this.getInnerBounds().y + this.getInnerBounds().height;
        n = this.getInnerBounds().y;
        for (int i = 0; i < fArray.length; i += 2) {
            int n3 = Math.round(fArray2[i]);
            if (n3 > this.getInnerBounds().x + this.getInnerBounds().width || n3 < this.getInnerBounds().x) continue;
            graphics2D.drawLine(n3, n, n3, n + this.ticSize);
            graphics2D.drawLine(n3, n2, n3, n2 - this.ticSize);
            if (DRAW_OBJECT_X_AXIS_GRID && this.shouldPaintGrid) {
                this.drawSingleGridline(graphics2D, n3, n + this.ticSize, n3, n2 - this.ticSize);
            }
            try {
                TextLayout textLayout = new TextLayout(this.model.getColumnValueAt((int)fArray[i]).toString(), this.getTickFont(), new FontRenderContext(null, true, false));
                if (this.isCenterLabelsBetweenTicks()) {
                    n3 += (int)((fArray2[i + 2] - (float)n3) / 2.0f);
                }
                textLayout.draw(graphics2D, n3 - (int)(textLayout.getBounds().getWidth() / 2.0), n2 + 5 + (int)textLayout.getBounds().getHeight());
                continue;
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private void drawSingleGridline(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        graphics2D.setStroke(this.gridStroke);
        graphics2D.setColor(this.gridColor);
        graphics2D.drawLine(n, n2, n3, n4);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }
}

