/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem;

import com.approximatrix.charting.Axis;
import com.approximatrix.charting.coordsystem.AbstractCoordSystem;
import com.approximatrix.charting.coordsystem.ClassicCoordSystemUtilities;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;

public class ClassicCoordSystem
extends AbstractCoordSystem
implements ChartDataModelListener {
    protected final FontRenderContext frc = new FontRenderContext(null, false, false);
    protected boolean shouldDrawArrows = true;
    protected boolean shouldPaintAltTick = true;
    public final int MINIMALMARGIN = 20;
    public final int ARROWLENGTH = 15;
    protected ChartDataModelConstraints constraints;
    protected ChartDataModelConstraints constraints2;
    protected ChartDataModel model;
    protected ClassicCoordSystemUtilities c;

    public ClassicCoordSystem(ChartDataModel chartDataModel) {
        this.constraints = chartDataModel.getChartDataModelConstraints(0);
        this.constraints2 = chartDataModel.getChartDataModelConstraints(1);
        this.model = chartDataModel;
        this.xaxis = new Axis(1, this.constraints);
        this.yaxis = new Axis(2, this.constraints);
        this.c = new ClassicCoordSystemUtilities(this, this.constraints, this.constraints2, this.model);
        this.dfY = new DecimalFormat();
        this.dfX = new DecimalFormat();
        chartDataModel.addChartDataModelListener(this);
        this.centerObjectLabelsBetweenTicks = !chartDataModel.isColumnNumeric();
    }

    public ClassicCoordSystem(ChartDataModel chartDataModel, String string, String string2) {
        this(chartDataModel);
        this.setXAxisUnit(string);
        this.setYAxisUnit(string2);
        chartDataModel.addChartDataModelListener(this);
        this.centerObjectLabelsBetweenTicks = !chartDataModel.isColumnNumeric();
    }

    public ClassicCoordSystem(ChartDataModel chartDataModel, DecimalFormat decimalFormat, boolean bl, boolean bl2, boolean bl3) {
        this(chartDataModel);
        this.dfY = decimalFormat;
        this.shouldDrawArrows = bl;
        this.shouldPaintAltTick = bl2;
        this.shouldPaintOnlyTick = bl3;
        chartDataModel.addChartDataModelListener(this);
        this.centerObjectLabelsBetweenTicks = !chartDataModel.isColumnNumeric();
    }

    public boolean isPaintAltTick() {
        return this.shouldPaintAltTick;
    }

    public void paintDefault(Graphics2D graphics2D) {
        if (!this.shouldPaintAxes) {
            return;
        }
        graphics2D.setColor(Color.black);
        Line2D line2D = this.c.getXAxisLine2D();
        Line2D line2D2 = this.c.getYAxisLine2D();
        graphics2D.draw(line2D);
        graphics2D.draw(line2D2);
        if (this.shouldPaintGrid) {
            this.c.drawYAxisGrid(graphics2D);
            if (this.model.isColumnNumeric()) {
                this.c.drawNumericalXAxisGrid(graphics2D);
            }
        }
        if (this.shouldDrawArrows) {
            graphics2D.drawLine((int)line2D.getX2(), (int)line2D.getY2(), (int)line2D.getX2() + 15, (int)line2D.getY2());
            graphics2D.fillPolygon(new int[]{(int)(line2D.getX2() + 5.0), (int)(line2D.getX2() + 5.0), (int)(line2D.getX2() + 15.0)}, new int[]{(int)line2D.getY2() - 3, (int)line2D.getY2() + 3, (int)line2D.getY2()}, 3);
        }
        graphics2D.setColor(Color.black);
        TextLayout textLayout = new TextLayout(this.getXAxisUnit(), this.getUnitFont(), new FontRenderContext(null, true, false));
        textLayout.draw(graphics2D, (float)line2D.getX2() + 5.0f, (float)line2D.getY2() + (float)textLayout.getBounds().getHeight() + 5.0f);
        if (this.shouldDrawArrows) {
            graphics2D.drawLine((int)line2D2.getX1(), (int)line2D2.getY1(), (int)line2D2.getX1(), (int)line2D2.getY1() - 15);
            graphics2D.fillPolygon(new int[]{(int)(line2D2.getX1() - 3.0), (int)(line2D2.getX1() + 3.0), (int)line2D2.getX1()}, new int[]{(int)(line2D2.getY1() - 5.0), (int)(line2D2.getY1() - 5.0), (int)line2D2.getY1() - 15}, 3);
        }
        graphics2D.setColor(Color.black);
        TextLayout textLayout2 = new TextLayout(this.getYAxisUnit(), this.getUnitFont(), new FontRenderContext(null, true, false));
        textLayout2.draw(graphics2D, (float)line2D2.getX1() - 6.0f - (float)textLayout2.getBounds().getWidth(), (float)line2D2.getY1() - textLayout.getDescent() - 3.0f);
        if (this.getSecondYAxis() != null) {
            Line2D line2D3 = this.c.getSecondYAxisLine2D();
            graphics2D.draw(line2D3);
        }
        if (this.model.isColumnNumeric()) {
            this.c.drawNumericalXAxisTicks(graphics2D);
        } else {
            this.c.drawXAxisTicks(graphics2D);
        }
        this.c.drawYAxisTicks(graphics2D);
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public DecimalFormat getYDecimalFormat() {
        return this.dfY;
    }

    public DecimalFormat getXDecimalFormat() {
        return this.dfX;
    }

    public boolean isDrawArrows() {
        return this.shouldDrawArrows;
    }

    public ChartDataModelConstraints getChartDataModelConstraints(int n) {
        if (n == 0) {
            return this.constraints;
        }
        if (n == 1) {
            return this.constraints2;
        }
        return null;
    }

    public void setMaximumXTicks(int n) {
        if (this.c == null) {
            return;
        }
        this.c.setMaximumXTicks(n);
        super.fireRenderChangeEvent();
    }

    public void setMaximumYTicks(int n) {
        if (this.c == null) {
            return;
        }
        this.c.setMaximumYTicks(n);
        super.fireRenderChangeEvent();
    }

    public int getMaximumXTicks() {
        if (this.c == null) {
            return 0;
        }
        return this.c.getMaximumXTicks();
    }

    public int getMaximumYTicks() {
        if (this.c == null) {
            return 0;
        }
        return this.c.getMaximumYTicks();
    }

    public void resetMaximumXTicks() {
        if (this.c == null) {
            return;
        }
        this.c.setMaximumXTicks(-1);
    }

    public void resetMaximumYTicks() {
        if (this.c == null) {
            return;
        }
        this.c.setMaximumYTicks(-1);
    }

    public void chartDataChanged(ChartDataModelEvent chartDataModelEvent) {
        this.setTransforms();
    }

    protected int computeBottomMargin() {
        return this.c.computeBottomMargin();
    }

    protected int computeLeftMargin() {
        return this.c.computeLeftMargin();
    }

    protected int computeRightMargin() {
        return this.c.computeRightMargin();
    }

    protected int computeTopMargin() {
        return this.c.computeTopMargin();
    }

    public void setCenterLabelsBetweenTicks(boolean bl) {
        if (this.model.isColumnNumeric() && bl) {
            throw new IllegalArgumentException("ClassicCoordSystem does not support centering numeric X-axis labels.");
        }
        super.setCenterLabelsBetweenTicks(bl);
    }
}

