/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.coordsystem.ClassicCoordSystem;
import com.approximatrix.charting.coordsystem.ticklocator.NumericTickLocator;
import com.approximatrix.charting.coordsystem.ticklocator.ObjectTickLocator;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class ClassicCoordSystemUtilities {
    private static final int MAX = 0;
    private static final int MIN = 1;
    private static final Color GRID_COLOR = Color.lightGray;
    private static final float[] DOT1 = new float[]{1.0f};
    private static final BasicStroke GRID_LINE_STYLE = new BasicStroke(1.0f, 0, 0, 10.0f, DOT1, 0.0f);
    protected final int marginOffset = 6;
    protected final int leftUnitBuffer = 10;
    protected ClassicCoordSystem c;
    protected ChartDataModelConstraints constraints;
    protected ChartDataModelConstraints constraints2;
    protected ChartDataModel model;
    private int estimated_x_ticks = 20;
    private int estimated_y_ticks = 20;
    private static final int DEFAULT_MAX_ACTUAL_TICKS = 40;
    private int maximum_x_ticks = 40;
    private int maximum_y_ticks = 40;
    private static final int SIMPLE_TICK_THRESHOLD = 4;
    private int tick_recursions = 0;
    private static final int STOP_TICK_RECURSIONS = 80;

    public ClassicCoordSystemUtilities(ClassicCoordSystem classicCoordSystem, ChartDataModelConstraints chartDataModelConstraints, ChartDataModelConstraints chartDataModelConstraints2, ChartDataModel chartDataModel) {
        this.c = classicCoordSystem;
        this.constraints = chartDataModelConstraints;
        this.constraints2 = chartDataModelConstraints2;
        this.model = chartDataModel;
    }

    public int computeLeftMargin() {
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        if (dArray[1] < dArray[0]) {
            int n = this.computeYAxisLabelWidth() + 6 + 10;
            TextLayout textLayout = new TextLayout(this.c.getYAxisUnit(), this.c.getUnitFont(), this.c.getFontRenderContext());
            n = Math.max((int)textLayout.getBounds().getWidth() + 10, n);
            int n2 = (int)(dArray[1] * (this.c.getBounds().getWidth() - (double)this.c.getRightMargin()) / (dArray[0] - dArray[1]));
            if (Math.abs(n2) > n && dArray[1] < 0.0) {
                n = 6;
            }
            int n3 = n;
            if ((n3 += 5) < this.c.MINIMALMARGIN) {
                n3 = this.c.MINIMALMARGIN;
            }
            return n3;
        }
        return this.c.MINIMALMARGIN;
    }

    public int computeRightMargin() {
        TextLayout textLayout = new TextLayout(this.c.getXAxisUnit(), this.c.getUnitFont(), this.c.getFontRenderContext());
        return Math.max((int)(textLayout.getBounds().getWidth() + (double)this.c.ARROWLENGTH / 3.0), this.c.ARROWLENGTH) + 5;
    }

    public int computeTopMargin() {
        TextLayout textLayout = new TextLayout(this.c.getYAxisUnit(), this.c.getUnitFont(), this.c.getFontRenderContext());
        return Math.max((int)(textLayout.getBounds().getHeight() + (double)this.c.ARROWLENGTH / 3.0 + (double)textLayout.getDescent()), this.c.ARROWLENGTH);
    }

    public int computeBottomMargin() {
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        if (dArray[1] <= 0.0 && dArray[0] > 0.0) {
            return this.c.MINIMALMARGIN;
        }
        dArray[1] = Math.abs(dArray[1]);
        dArray[0] = Math.abs(dArray[0]);
        TextLayout textLayout = new TextLayout(this.c.getXAxisUnit(), this.c.getUnitFont(), this.c.getFontRenderContext());
        int n = this.computeXAxisLabelHeight() + 6;
        n = Math.max(n, (int)textLayout.getBounds().getHeight() + 6);
        int n2 = (int)((double)n - dArray[1] / (dArray[1] + dArray[0]) * (this.c.getBounds().getHeight() - (double)this.c.getTopMargin()));
        if ((n2 += 10) < this.c.MINIMALMARGIN) {
            n2 = this.c.MINIMALMARGIN;
        }
        return n2;
    }

    public int computeXAxisLabelHeight() {
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        double d = ChartUtilities.calculateTickSpacing(dArray[1], dArray[0]);
        int n = 0;
        boolean bl = false;
        DecimalFormat decimalFormat = this.c.getXDecimalFormat();
        FontRenderContext fontRenderContext = this.c.getFontRenderContext();
        Font font = this.c.getTickFont();
        for (double d2 = dArray[1]; d2 <= dArray[0]; d2 += d) {
            if (bl) {
                String string = decimalFormat.format(d2);
                Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
                n = Math.max(n, (int)rectangle2D.getHeight());
            }
            bl = !bl;
        }
        return n;
    }

    public int computeYAxisLabelWidth() {
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        double[] dArray2 = new NumericTickLocator(dArray[0], dArray[1], this.estimated_y_ticks, this.maximum_y_ticks).getTickMarkLocations();
        if (dArray2 == null) {
            return 0;
        }
        if (dArray2.length == 0) {
            return 0;
        }
        int n = 0;
        boolean bl = false;
        DecimalFormat decimalFormat = this.c.getYDecimalFormat();
        FontRenderContext fontRenderContext = this.c.getFontRenderContext();
        Font font = this.c.getTickFont();
        for (int i = 0; i < dArray2.length; ++i) {
            if (bl) {
                String string = decimalFormat.format(dArray2[i]);
                Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
                n = Math.max((int)Math.ceil(rectangle2D.getWidth()), n);
            }
            bl = !bl;
        }
        return n;
    }

    public void drawNumericalXAxisTicks(Graphics2D graphics2D) {
        AffineTransform affineTransform = this.c.getTransform(0);
        double d = 0.0;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        try {
            dArray = this.safeMaxMin(this.constraints.getMaximumX().doubleValue(), this.constraints.getMinimumX().doubleValue());
        }
        catch (NullPointerException nullPointerException) {
            dArray[0] = 0.0;
            dArray[1] = 1.0;
        }
        try {
            dArray2 = this.safeMaxMin(this.constraints.getMaximumY().doubleValue(), this.constraints.getMinimumY().doubleValue());
        }
        catch (NullPointerException nullPointerException) {
            dArray2[0] = 0.0;
            dArray2[1] = 1.0;
        }
        if (dArray2[1] > 0.0) {
            d = dArray2[1];
        } else if (dArray2[0] < 0.0) {
            d = dArray2[0];
        }
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Line2D.Double double_2 = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        DecimalFormat decimalFormat = this.c.getXDecimalFormat();
        FontRenderContext fontRenderContext = this.c.getFontRenderContext();
        Font font = this.c.getTickFont();
        boolean bl = true;
        graphics2D.setFont(font);
        boolean bl2 = this.c.isPaintLabels();
        double[] dArray3 = new NumericTickLocator(dArray[0], dArray[1], this.estimated_x_ticks, this.maximum_x_ticks).getTickMarkLocations();
        if (dArray3 == null) {
            return;
        }
        for (int i = 0; i < dArray3.length; ++i) {
            if (dArray3[i] < dArray[1] || dArray3[i] > dArray[0]) continue;
            ((Point2D)double_).setLocation(dArray3[i], d);
            Point2D point2D = affineTransform.transform(double_, null);
            ((Line2D)double_2).setLine(point2D.getX(), point2D.getY() - 3.0, point2D.getX(), point2D.getY() + 3.0);
            graphics2D.draw(double_2);
            if (!bl || !bl2) continue;
            String string = decimalFormat.format(dArray3[i]);
            Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
            graphics2D.drawString(string, (float)(point2D.getX() - rectangle2D.getWidth() / 2.0), (float)(point2D.getY() + rectangle2D.getHeight() + 6.0));
        }
    }

    public void drawXAxisTicks(Graphics2D graphics2D) {
        AffineTransform affineTransform = this.c.getTransform(0);
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumX().doubleValue(), this.constraints.getMinimumX().doubleValue());
        int[] nArray = new int[2];
        nArray[1] = (int)Math.floor(dArray[1]);
        nArray[0] = (int)Math.ceil(dArray[0]);
        double d = 0.0;
        double[] dArray2 = this.safeMaxMin(this.constraints.getMaximumY().doubleValue(), this.constraints.getMinimumY().doubleValue());
        if (dArray2[1] > 0.0) {
            d = dArray2[1];
        } else if (dArray2[0] < 0.0) {
            d = dArray2[0];
        }
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D point2D = null;
        Point2D point2D2 = null;
        Line2D.Double double_2 = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        FontRenderContext fontRenderContext = this.c.getFontRenderContext();
        Font font = this.c.getTickFont();
        boolean bl = this.c.isPaintLabels();
        graphics2D.setFont(font);
        int[] nArray2 = new ObjectTickLocator(nArray[1], nArray[0], this.getMaximumXTicks()).getTickMarkLocations();
        if (nArray2 == null) {
            return;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            Rectangle2D rectangle2D;
            String string;
            int n = nArray2[i] - 1;
            ((Point2D)double_).setLocation(n + 1, d);
            point2D = affineTransform.transform(double_, null);
            ((Line2D)double_2).setLine(point2D.getX(), point2D.getY() - 3.0, point2D.getX(), point2D.getY() + 3.0);
            if (n + 1 < nArray[0]) {
                graphics2D.draw(double_2);
            }
            if (!this.c.isCenterLabelsBetweenTicks() && bl && this.model.getColumnValueAt(n) != null) {
                string = this.model.getColumnValueAt(n).toString();
                rectangle2D = font.getStringBounds(string, fontRenderContext);
                graphics2D.drawString(string, (float)(point2D.getX() - rectangle2D.getWidth() / 2.0), (float)(point2D.getY() + rectangle2D.getHeight() + 6.0));
            }
            if (point2D2 != null && bl && this.c.isCenterLabelsBetweenTicks() && this.model.getColumnValueAt(n) != null) {
                string = this.model.getColumnValueAt(n).toString();
                rectangle2D = font.getStringBounds(string, fontRenderContext);
                graphics2D.drawString(string, (float)(point2D2.getX() + (point2D.getX() - point2D2.getX()) / 2.0 - rectangle2D.getWidth() / 2.0), (float)(point2D.getY() + rectangle2D.getHeight() + 6.0));
            }
            point2D2 = point2D;
        }
    }

    public void drawYAxisTicks(Graphics2D graphics2D) {
        AffineTransform affineTransform = this.c.getTransform(0);
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        double d = 0.0;
        double[] dArray2 = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        if (dArray2[1] > 0.0) {
            d = dArray2[1];
        } else if (dArray2[0] < 0.0 && this.c.getSecondYAxis() != null) {
            d = dArray2[0];
        }
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Line2D.Double double_2 = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        boolean bl = true;
        DecimalFormat decimalFormat = this.c.getYDecimalFormat();
        FontRenderContext fontRenderContext = this.c.getFontRenderContext();
        Font font = this.c.getTickFont();
        Color color = graphics2D.getColor();
        graphics2D.setFont(font);
        boolean bl2 = this.c.isPaintLabels();
        double[] dArray3 = new NumericTickLocator(dArray[0], dArray[1], this.estimated_y_ticks, this.maximum_y_ticks).getTickMarkLocations();
        if (dArray3 == null) {
            return;
        }
        for (int i = 0; i < dArray3.length; ++i) {
            Object object;
            if (dArray3[i] < dArray[1] || dArray3[i] > dArray[0]) continue;
            ((Point2D)double_).setLocation(d, dArray3[i]);
            Point2D point2D = affineTransform.transform(double_, null);
            ((Line2D)double_2).setLine(point2D.getX() - 3.0, point2D.getY(), point2D.getX() + 3.0, point2D.getY());
            graphics2D.draw(double_2);
            if (dArray3[i] != dArray[1] && !this.c.isPaintOnlyTick()) {
                object = this.getXAxisLine2D();
                ((Line2D)double_2).setLine(point2D.getX() + 3.0, point2D.getY(), ((Line2D)object).getX2(), point2D.getY());
                graphics2D.setColor(Color.lightGray);
                graphics2D.draw(double_2);
                graphics2D.setColor(color);
            }
            if (!bl2 || !bl && this.c.isPaintAltTick()) continue;
            object = decimalFormat.format(dArray3[i]);
            Rectangle2D rectangle2D = font.getStringBounds((String)object, fontRenderContext);
            graphics2D.drawString((String)object, (float)(point2D.getX() - rectangle2D.getWidth() - 6.0), (float)(point2D.getY() + rectangle2D.getHeight() / 2.0));
        }
    }

    public void drawYAxisGrid(Graphics2D graphics2D) {
        Point2D[] point2DArray = this.getYTickLocations();
        AffineTransform affineTransform = this.c.getTransform(0);
        double d = 0.0;
        double d2 = 0.0;
        if (point2DArray == null) {
            return;
        }
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(GRID_LINE_STYLE);
        graphics2D.setColor(GRID_COLOR);
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        d = dArray[0];
        d2 = dArray[1];
        double[] dArray2 = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        for (int i = 0; i < point2DArray.length; ++i) {
            if (point2DArray[i].getY() < dArray2[1] || point2DArray[i].getY() > dArray2[0]) continue;
            Point2D point2D = new Point2D.Double(d2, point2DArray[i].getY());
            Point2D point2D2 = new Point2D.Double(d, point2DArray[i].getY());
            point2D = affineTransform.transform(point2D, null);
            point2D2 = affineTransform.transform(point2D2, null);
            Line2D.Double double_ = new Line2D.Double(point2D, point2D2);
            graphics2D.draw(double_);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    public void drawNumericalXAxisGrid(Graphics2D graphics2D) {
        Point2D[] point2DArray = this.getXTickLocations();
        AffineTransform affineTransform = this.c.getTransform(0);
        double d = 0.0;
        double d2 = 0.0;
        if (point2DArray == null) {
            return;
        }
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(GRID_LINE_STYLE);
        graphics2D.setColor(GRID_COLOR);
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        d = dArray[0];
        d2 = dArray[1];
        double[] dArray2 = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        for (int i = 0; i < point2DArray.length; ++i) {
            if (point2DArray[i].getX() < dArray2[1] || point2DArray[i].getX() > dArray2[0]) continue;
            Point2D point2D = new Point2D.Double(point2DArray[i].getX(), d2);
            Point2D point2D2 = new Point2D.Double(point2DArray[i].getX(), d);
            point2D = affineTransform.transform(point2D, null);
            point2D2 = affineTransform.transform(point2D2, null);
            Line2D.Double double_ = new Line2D.Double(point2D, point2D2);
            graphics2D.draw(double_);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    private Point2D[] getYTickLocations() {
        Point2D[] point2DArray = null;
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        double d = 0.0;
        double[] dArray2 = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        if (dArray2[1] > 0.0) {
            d = dArray2[1];
        } else if (dArray2[0] < 0.0 && this.c.getSecondYAxis() != null) {
            d = dArray2[0];
        }
        double[] dArray3 = new NumericTickLocator(dArray[0], dArray[1], this.estimated_y_ticks, this.maximum_y_ticks).getTickMarkLocations();
        if (dArray3 == null) {
            return null;
        }
        point2DArray = new Point2D[dArray3.length];
        for (int i = 0; i < dArray3.length; ++i) {
            point2DArray[i] = new Point2D.Double(d, dArray3[i]);
        }
        return point2DArray;
    }

    private Point2D[] getXTickLocations() {
        Point2D[] point2DArray = null;
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        double d = 0.0;
        double[] dArray2 = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        if (dArray2[1] > 0.0) {
            d = dArray2[1];
        } else if (dArray2[0] < 0.0) {
            d = dArray2[0];
        }
        double[] dArray3 = new NumericTickLocator(dArray[0], dArray[1], this.estimated_x_ticks, this.maximum_x_ticks).getTickMarkLocations();
        if (dArray3 == null) {
            return null;
        }
        point2DArray = new Point2D[dArray3.length];
        for (int i = 0; i < dArray3.length; ++i) {
            point2DArray[i] = new Point2D.Double(dArray3[i], d);
        }
        return point2DArray;
    }

    public Line2D getXAxisLine2D() {
        double d = 0.0;
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        if (dArray[1] > 0.0) {
            d = dArray[1];
        } else if (dArray[0] < 0.0) {
            d = dArray[0];
        }
        AffineTransform affineTransform = this.c.getTransform(0);
        double[] dArray2 = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        Point2D point2D = affineTransform.transform(new Point2D.Double(dArray2[1], d), null);
        Point2D point2D2 = affineTransform.transform(new Point2D.Double(dArray2[0], d), null);
        return new Line2D.Double(point2D, point2D2);
    }

    public Line2D getYAxisLine2D() {
        double d = 0.0;
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        if (dArray[1] > 0.0) {
            d = dArray[1];
        } else if (dArray[0] < 0.0 && this.c.getSecondYAxis() != null) {
            d = dArray[0];
        }
        AffineTransform affineTransform = this.c.getTransform(0);
        double[] dArray2 = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        Point2D point2D = affineTransform.transform(new Point2D.Double(d, dArray2[0]), null);
        Point2D point2D2 = affineTransform.transform(new Point2D.Double(d, dArray2[1]), null);
        return new Line2D.Double(point2D, point2D2);
    }

    public Line2D getSecondYAxisLine2D() {
        double[] dArray = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        double d = dArray[0];
        AffineTransform affineTransform = this.c.getTransform(1);
        double[] dArray2 = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        Point2D point2D = affineTransform.transform(new Point2D.Double(d, dArray2[0]), null);
        Point2D point2D2 = affineTransform.transform(new Point2D.Double(d, dArray2[1]), null);
        return new Line2D.Double(point2D, point2D2);
    }

    private double[] computeTicMarkLocations(double d, double d2, int n, int n2) {
        return this.computeTicMarkLocations(d, d2, n, n2, false);
    }

    private double[] computeTicMarkLocations(double d, double d2, int n, int n2, boolean bl) {
        this.tick_recursions = 0;
        if (n == 0) {
            return this.computeTicMarkLocations(d, d2, 2, n2, true);
        }
        if (n <= 4 || bl) {
            return this.simpleTics(d, d2, n);
        }
        return this.performAutoScale(d, d2, n, n2);
    }

    private double[] simpleTics(double d, double d2, int n) {
        if (n == 0) {
            return null;
        }
        double d3 = (d - d2) / (double)(n - 1);
        double[] dArray = new double[n];
        dArray[0] = d2;
        for (int i = 1; i < n; ++i) {
            dArray[i] = dArray[i - 1] + d3;
        }
        return dArray;
    }

    private double[] performAutoScale(double d, double d2, int n, int n2) {
        int n3 = n;
        if (n < 10 && this.tick_recursions == 0) {
            n3 = 10;
        }
        double d3 = (d - d2) / (double)n3;
        double d4 = Math.log(d3) / Math.log(10.0);
        int n4 = (int)Math.round(d4);
        ++this.tick_recursions;
        int n5 = 0;
        if (n4 < 0) {
            n5 = -n4;
        }
        double d5 = Math.pow(10.0, d4 - (double)n4);
        double d6 = Math.pow(10.0, n4);
        if (d5 > 5.0) {
            d6 *= 10.0;
            if (--n5 < 0) {
                n5 = 0;
            }
        } else if (d5 > 2.0) {
            d6 = 5.0;
        } else if (d5 > 1.0) {
            d6 = 2.0;
        }
        double d7 = Math.floor(d2 / d6) * d6;
        double d8 = Math.floor(d / d6 + 0.99999) * d6;
        int n6 = (int)Math.floor((d8 - d7) / d6 + 1.0E-5);
        if (n6 > n2 && n6 / 2 <= n2) {
            n6 /= 2;
            d6 *= 2.0;
        }
        if (n6 > n2 && n2 < 5 || this.tick_recursions > Math.min(80, n - 2)) {
            return this.simpleTics(d, d2, n);
        }
        if (n6 > n2) {
            return this.performAutoScale(d, d2, n - 1, n2);
        }
        if (n6 < n / 2) {
            n6 *= 2;
            d6 /= 2.0;
        }
        if (d6 == 0.0) {
            n6 = 3;
            d7 = d2;
            d6 = (d - d2) / 2.0;
        }
        double[] dArray = new double[n6 + 1];
        dArray[0] = d7;
        for (int i = 1; i <= n6; ++i) {
            dArray[i] = dArray[i - 1] + d6;
        }
        return dArray;
    }

    public void setEstimatedXTicks(int n) {
        this.estimated_x_ticks = n;
        this.checkMaxTickConsistency();
    }

    public void setEstimatedYTicks(int n) {
        this.estimated_y_ticks = n;
        this.checkMaxTickConsistency();
    }

    public int getEstimatedXTicks() {
        return this.estimated_x_ticks;
    }

    public int getEstimatedYTicks() {
        return this.estimated_x_ticks;
    }

    public void setMaximumXTicks(int n) {
        this.maximum_x_ticks = n >= 0 ? n : 40;
        this.checkMaxTickConsistency();
    }

    public void setMaximumYTicks(int n) {
        this.maximum_y_ticks = n >= 0 ? n : 40;
        this.checkMaxTickConsistency();
    }

    public int getMaximumXTicks() {
        return this.maximum_x_ticks;
    }

    public int getMaximumYTicks() {
        return this.maximum_y_ticks;
    }

    private void checkMaxTickConsistency() {
        if (this.maximum_x_ticks < this.estimated_x_ticks) {
            this.setEstimatedXTicks(this.maximum_x_ticks);
        }
        if (this.maximum_y_ticks < this.estimated_y_ticks) {
            this.setEstimatedYTicks(this.maximum_y_ticks);
        }
    }

    private double[] safeMaxMin(Number number, Number number2) {
        try {
            return this.safeMaxMin(number.doubleValue(), number2.doubleValue());
        }
        catch (NullPointerException nullPointerException) {
            double[] dArray = new double[]{0.0, 1.0};
            return dArray;
        }
    }

    private double[] safeMaxMin(double d, double d2) {
        double[] dArray = new double[2];
        if (d - d2 == 0.0) {
            if (d == 0.0) {
                d = 1.0;
                d2 = -1.0;
            } else {
                d = 1.1 * d;
                d2 = 0.9 * d2;
            }
        }
        if (d < d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }
}

