/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem.ticklocator;

public class NumericTickLocator {
    private static final int SIMPLE_TICK_THRESHOLD = 4;
    private static final int STOP_TICK_RECURSIONS = 80;
    private double max = 0.0;
    private double min = 1.0;
    private int maxtics = 40;
    private int destics = 20;
    private boolean simple = false;
    private int tick_recursions = 0;

    public NumericTickLocator(double d, double d2, int n, int n2) {
        this(d, d2, n, n2, false);
    }

    public NumericTickLocator(double d, double d2, int n, int n2, boolean bl) {
        this.max = d;
        this.min = d2;
        this.maxtics = n2;
        this.destics = n;
        this.simple = bl;
    }

    public double[] getTickMarkLocations() {
        return this.computeTicMarkLocations(this.max, this.min, this.destics, this.maxtics, this.simple);
    }

    private double[] computeTicMarkLocations(double d, double d2, int n, int n2, boolean bl) {
        this.tick_recursions = 0;
        if (n == 0) {
            return this.computeTicMarkLocations(d, d2, 2, n2, true);
        }
        if (n <= 4 || bl) {
            return this.simpleTics(d, d2, n);
        }
        return this.performAutoScale(d, d2, n, n2);
    }

    private double[] simpleTics(double d, double d2, int n) {
        if (n == 0) {
            return null;
        }
        double d3 = (d - d2) / (double)(n - 1);
        double[] dArray = new double[n];
        dArray[0] = d2;
        for (int i = 1; i < n; ++i) {
            dArray[i] = dArray[i - 1] + d3;
        }
        return dArray;
    }

    private double[] performAutoScale(double d, double d2, int n, int n2) {
        int n3 = n;
        if (n < 10 && this.tick_recursions == 0) {
            n3 = 10;
        }
        double d3 = (d - d2) / (double)n3;
        double d4 = Math.log(d3) / Math.log(10.0);
        int n4 = (int)Math.round(d4);
        ++this.tick_recursions;
        int n5 = 0;
        if (n4 < 0) {
            n5 = -n4;
        }
        double d5 = Math.pow(10.0, d4 - (double)n4);
        double d6 = Math.pow(10.0, n4);
        if (d5 > 5.0) {
            d6 *= 10.0;
            if (--n5 < 0) {
                n5 = 0;
            }
        } else if (d5 > 2.0) {
            d6 = 5.0;
        } else if (d5 > 1.0) {
            d6 = 2.0;
        }
        double d7 = Math.floor(d2 / d6) * d6;
        double d8 = Math.floor(d / d6 + 0.99999) * d6;
        int n6 = (int)Math.floor((d8 - d7) / d6 + 1.0E-5);
        if (n6 > n2 && n6 / 2 <= n2) {
            n6 /= 2;
            d6 *= 2.0;
        }
        if (n6 > n2 && n2 < 5 || this.tick_recursions > Math.min(80, n - 2)) {
            return this.simpleTics(d, d2, n);
        }
        if (n6 > n2) {
            return this.performAutoScale(d, d2, n - 1, n2);
        }
        if (n6 < n / 2) {
            n6 *= 2;
            d6 /= 2.0;
        }
        if (d6 == 0.0) {
            n6 = 3;
            d7 = d2;
            d6 = (d - d2) / 2.0;
        }
        double[] dArray = new double[Math.min(n6 + 1, n2)];
        dArray[0] = d7;
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = dArray[i - 1] + d6;
        }
        return dArray;
    }
}

