/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ChartDataModel;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;

public abstract class AbstractChartDataModel
implements ChartDataModel {
    protected EventListenerList listener = new EventListenerList();
    protected boolean autoscale = true;
    protected double maxcolumn;
    protected double mincolumn;
    protected Number maxvalue;
    protected Number minvalue;

    public void removeChartDataModelListener(ChartDataModelListener chartDataModelListener) {
        this.listener.remove(ChartDataModelListener.class, chartDataModelListener);
    }

    public void addChartDataModelListener(ChartDataModelListener chartDataModelListener) {
        Object[] objectArray = this.listener.getListenerList();
        boolean bl = false;
        for (int i = objectArray.length - 1; i >= 1; i -= 2) {
            if (objectArray[i] != chartDataModelListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.listener.add(ChartDataModelListener.class, chartDataModelListener);
        }
        this.listener.add(ChartDataModelListener.class, chartDataModelListener);
    }

    public boolean isColumnNumeric() {
        return false;
    }

    public void setValueAt(int n, int n2, Object object) {
    }

    public Class getColumnClass() {
        return Object.class;
    }

    public void fireChartDataModelChangedEvent(Object object) {
        ChartDataModelEvent chartDataModelEvent = new ChartDataModelEvent(object);
        Object[] objectArray = this.listener.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChartDataModelListener.class) continue;
            ((ChartDataModelListener)objectArray[i + 1]).chartDataChanged(chartDataModelEvent);
        }
    }

    public int getAxisBinding(int n) {
        return 0;
    }

    public void setAxisBinding(int n, int n2) {
    }

    public void setAutoScale(boolean bl) {
        this.autoscale = bl;
    }

    public boolean isAutoScale() {
        return this.autoscale;
    }

    public void setManualScale(boolean bl) {
        this.autoscale = !bl;
    }

    public boolean isManualScale() {
        return !this.autoscale;
    }

    public void setMaximumColumnValue(double d) {
        this.maxcolumn = d;
    }

    public void setMinimumColumnValue(double d) {
        this.mincolumn = d;
    }

    public void setMaximumValue(Number number) {
        this.maxvalue = number;
    }

    public void setMinimumValue(Number number) {
        this.minvalue = number;
    }

    public double getManualMaximumColumnValue() {
        return this.maxcolumn;
    }

    public double getManualMinimumColumnValue() {
        return this.mincolumn;
    }

    public Number getManualMaximumValue() {
        return this.maxvalue;
    }

    public Number getManualMinimumValue() {
        return this.minvalue;
    }

    public Number getManualMaximumX() {
        return new Double(this.maxcolumn);
    }

    public Number getManualMaximumY() {
        return this.maxvalue;
    }

    public Number getManualMinimumX() {
        return new Double(this.mincolumn);
    }

    public Number getManualMinimumY() {
        return this.minvalue;
    }

    public void setMaximumValueX(Number number) {
        if (number == null) {
            return;
        }
        this.maxcolumn = number.doubleValue();
    }

    public void setMaximumValueY(Number number) {
        this.maxvalue = number;
    }

    public void setMinimumValueX(Number number) {
        if (number == null) {
            return;
        }
        this.mincolumn = number.doubleValue();
    }

    public void setMinimumValueY(Number number) {
        this.minvalue = number;
    }

    public String getDataSetName(int n) {
        return "Dataset " + n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            AbstractChartDataModel abstractChartDataModel = (AbstractChartDataModel)object;
            if (this.getDataSetNumber() != abstractChartDataModel.getDataSetNumber()) {
                return false;
            }
            for (int i = 0; i < this.getDataSetNumber(); ++i) {
                if (!this.getDataSetName(i).equals(abstractChartDataModel.getDataSetName(i))) {
                    return false;
                }
                for (int j = 0; j < this.getDataSetLength(j); ++j) {
                    if (this.getColumnValueAt(j).equals(abstractChartDataModel.getColumnValueAt(j))) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected abstract TreeSet getOrderedValues(int var1);

    protected abstract double getFirstColumnValue();

    protected abstract double getLastColumnValue();
}

