/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.model.DataSet;
import com.approximatrix.charting.model.DefaultChartDataModelConstraints;
import com.approximatrix.charting.model.DefaultDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;

public class DefaultChartDataModel
extends AbstractChartDataModel {
    protected TreeSet columnSet = new TreeSet();
    protected ArrayList data = new ArrayList();
    protected HashMap valuesbyaxis = new HashMap();
    protected ChartDataModelConstraints constraints1;
    protected ChartDataModelConstraints constraints2;

    public DefaultChartDataModel() {
        TreeSet treeSet = new TreeSet();
        this.valuesbyaxis.put(new Integer(0), treeSet);
        TreeSet treeSet2 = new TreeSet();
        this.valuesbyaxis.put(new Integer(1), treeSet2);
        this.constraints1 = new DefaultChartDataModelConstraints(this, 0);
        this.constraints2 = new DefaultChartDataModelConstraints(this, 1);
    }

    public DefaultChartDataModel(Number[][] numberArray, double[] dArray, String[] stringArray) {
        this();
        this.columnSet.addAll(Arrays.asList(ChartUtilities.transformArray(dArray)));
        TreeSet treeSet = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(treeSet, numberArray);
        this.trimSet(treeSet);
        for (int i = 0; i < numberArray.length; ++i) {
            this.data.add(new DefaultDataSet(numberArray[i], ChartUtilities.transformArray(dArray), 0, stringArray[i]));
        }
    }

    public DefaultChartDataModel(int[][] nArray, double[] dArray, String[] stringArray) {
        this();
        Number[][] numberArray = ChartUtilities.transformArray(nArray);
        this.columnSet.addAll(Arrays.asList(ChartUtilities.transformArray(dArray)));
        TreeSet treeSet = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(treeSet, numberArray);
        this.trimSet(treeSet);
        for (int i = 0; i < nArray.length; ++i) {
            this.data.add(new DefaultDataSet(numberArray[i], ChartUtilities.transformArray(dArray), 0, stringArray[i]));
        }
    }

    public DefaultChartDataModel(double[][] dArray, double[] dArray2, String[] stringArray) {
        this();
        Number[][] numberArray = ChartUtilities.transformArray(dArray);
        this.columnSet.addAll(Arrays.asList(ChartUtilities.transformArray(dArray2)));
        TreeSet treeSet = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(treeSet, numberArray);
        this.trimSet(treeSet);
        for (int i = 0; i < dArray.length; ++i) {
            this.data.add(new DefaultDataSet(numberArray[i], ChartUtilities.transformArray(dArray2), 0, stringArray[i]));
        }
    }

    public DefaultChartDataModel(DataSet[] dataSetArray) {
        this();
        for (int i = 0; i < dataSetArray.length; ++i) {
            this.data.add(dataSetArray[i]);
            TreeSet treeSet = (TreeSet)this.valuesbyaxis.get(new Integer(dataSetArray[i].getYAxis()));
            for (int j = 0; j < dataSetArray[i].getDataSetLength(); ++j) {
                this.columnSet.add(dataSetArray[i].getColumnValueAt(j));
                treeSet.add(dataSetArray[i].getValueAt(j));
                this.trimSet(treeSet);
            }
        }
    }

    public int getDataSetLength(int n) {
        return ((DataSet)this.data.get(n)).getDataSetLength();
    }

    public int getDataSetNumber() {
        return this.data.size();
    }

    public String getDataSetName(int n) {
        return ((DataSet)this.data.get(n)).getTitle();
    }

    public int getAxisBinding(int n) {
        return ((DataSet)this.data.get(n)).getYAxis();
    }

    public boolean isColumnNumeric() {
        return true;
    }

    public Class getColumnClass() {
        return Double.class;
    }

    public Number getValueAt(int n, int n2) {
        return (Number)((DataSet)this.data.get(n)).getValueAt(n2);
    }

    public Object getColumnValueAt(int n) {
        return null;
    }

    public Object getColumnValueAt(int n, int n2) {
        if (n2 < this.getDataSetLength(n)) {
            return new Double(((Number)((DataSet)this.data.get(n)).getColumnValueAt(n2)).doubleValue());
        }
        return null;
    }

    public ChartDataModelConstraints getChartDataModelConstraints(int n) {
        if (n == 0) {
            return this.constraints1;
        }
        return this.constraints2;
    }

    public void setChartDataModelConstraints(int n, ChartDataModelConstraints chartDataModelConstraints) {
        if (n == 0) {
            this.constraints1 = chartDataModelConstraints;
        } else {
            this.constraints2 = chartDataModelConstraints;
        }
    }

    protected void trimSet(TreeSet treeSet) {
        while (((Number)treeSet.first()).doubleValue() == Double.NEGATIVE_INFINITY) {
            treeSet.remove(treeSet.first());
        }
        double d = ((Number)treeSet.last()).doubleValue();
        while (d == Double.POSITIVE_INFINITY || d != d) {
            treeSet.remove(treeSet.last());
            d = ((Number)treeSet.last()).doubleValue();
        }
    }

    protected TreeSet getOrderedValues(int n) {
        return (TreeSet)this.valuesbyaxis.get(new Integer(n));
    }

    protected double getFirstColumnValue() {
        return ((Number)this.columnSet.first()).doubleValue();
    }

    protected double getLastColumnValue() {
        return ((Number)this.columnSet.last()).doubleValue();
    }
}

