/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import java.util.TreeSet;

public class DefaultChartDataModelConstraints
implements ChartDataModelConstraints {
    protected AbstractChartDataModel model;
    protected int axis;
    protected boolean allowManualColScale = true;

    public DefaultChartDataModelConstraints(AbstractChartDataModel abstractChartDataModel, int n) {
        this.model = abstractChartDataModel;
        this.axis = n;
    }

    public DefaultChartDataModelConstraints(AbstractChartDataModel abstractChartDataModel, int n, boolean bl) {
        this(abstractChartDataModel, n);
        this.allowManualColScale = bl;
    }

    public Number getMaximumValue() {
        return this.getMaximumY();
    }

    public Number getMaximumY() {
        TreeSet treeSet = this.model.getOrderedValues(this.axis);
        if (treeSet.size() == 0) {
            return new Integer(1);
        }
        if (this.model.isManualScale()) {
            return this.model.getManualMaximumY();
        }
        if (this.model.isAutoScale()) {
            double d;
            double d2 = ((Number)treeSet.first()).doubleValue();
            if (d2 / (d = ((Number)treeSet.last()).doubleValue()) > 0.95) {
                return new Double(ChartUtilities.performAutoScale(d2 / 2.0, 2.0 * d)[1]);
            }
            return new Double(ChartUtilities.performAutoScale(d2, d)[1]);
        }
        return (Number)treeSet.last();
    }

    public Number getMinimumValue() {
        return this.getMinimumY();
    }

    public Number getMinimumY() {
        TreeSet treeSet = this.model.getOrderedValues(this.axis);
        if (treeSet.size() == 0) {
            return new Integer(0);
        }
        if (this.model.isManualScale()) {
            return this.model.getManualMinimumY();
        }
        if (this.model.isAutoScale()) {
            double d;
            double d2 = ((Number)treeSet.first()).doubleValue();
            if (d2 / (d = ((Number)treeSet.last()).doubleValue()) > 0.95) {
                return new Double(ChartUtilities.performAutoScale(d2 / 2.0, 2.0 * d)[0]);
            }
            return new Double(ChartUtilities.performAutoScale(d2, d)[0]);
        }
        return (Number)treeSet.first();
    }

    public double getMinimumColumnValue() {
        Number number = this.getMinimumX();
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public Number getMinimumX() {
        if (this.model.isManualScale() && this.allowManualColScale) {
            return this.model.getManualMinimumX();
        }
        if (this.model.isAutoScale() && this.model.isColumnNumeric()) {
            return new Double(ChartUtilities.performAutoScale(this.model.getFirstColumnValue(), this.model.getLastColumnValue())[0]);
        }
        return new Double(this.model.getFirstColumnValue());
    }

    public double getMaximumColumnValue() {
        Number number = this.getMaximumX();
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public Number getMaximumX() {
        if (this.model.isManualScale() && this.allowManualColScale) {
            return this.model.getManualMaximumX();
        }
        if (this.model.isAutoScale() && this.model.isColumnNumeric()) {
            return new Double(ChartUtilities.performAutoScale(this.model.getFirstColumnValue(), this.model.getLastColumnValue())[1]);
        }
        return new Double(this.model.getLastColumnValue());
    }
}

