/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.SimpleStrokeDefs;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.model.MultiScatterDataModelConstraints;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class MultiScatterDataModel
implements ChartDataModel {
    private ArrayList<DataSet> data = null;
    private ArrayList<String> names = null;
    private ArrayList<SeriesProperties> properties = null;
    protected EventListenerList listener = new EventListenerList();
    protected boolean autoscale = true;
    protected Double manual_max_x;
    protected Double manual_min_x;
    protected Double manual_max_y;
    protected Double manual_min_y;
    private Double max_x;
    private Double max_y;
    private Double min_x;
    private Double min_y;
    protected ChartDataModelConstraints constraints = null;

    public MultiScatterDataModel() {
        this.data = new ArrayList();
        this.names = new ArrayList();
        this.properties = new ArrayList();
        this.clearBuffers();
        this.constraints = new MultiScatterDataModelConstraints(this);
    }

    public void addData(double[] dArray, double[] dArray2, String string) {
        this.names.add(string);
        this.properties.add(new SeriesProperties());
        this.data.add(new DataSet(dArray, dArray2));
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public void addData(double[][] dArray, String string) {
        this.names.add(string);
        this.properties.add(new SeriesProperties());
        this.data.add(new DataSet(dArray));
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public void removeData(String string) {
        for (int i = 0; i < this.names.size(); ++i) {
            String string2 = this.names.get(i);
            if (string2.compareTo(string) != 0) continue;
            this.removeData(i);
            break;
        }
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public void updateData(String string, double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.names.size(); ++i) {
            String string2 = this.names.get(i);
            if (string2.compareTo(string) != 0) continue;
            this.data.set(i, new DataSet(dArray, dArray2));
            break;
        }
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public void updateData(String string, double[][] dArray) {
        for (int i = 0; i < this.names.size(); ++i) {
            String string2 = this.names.get(i);
            if (string2.compareTo(string) != 0) continue;
            this.data.set(i, new DataSet(dArray));
            break;
        }
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public boolean isSeries(String string) {
        boolean bl = false;
        for (int i = 0; i < this.names.size(); ++i) {
            String string2 = this.names.get(i);
            if (string2.compareTo(string) != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void removeData(int n) {
        if (n > this.names.size() || n > this.data.size()) {
            return;
        }
        this.names.remove(n);
        this.data.remove(n);
        if (n < this.properties.size()) {
            this.properties.remove(n);
        }
        this.clearBuffers();
        this.fireChartDataModelChangedEvent(this);
    }

    public int getNumberSeries() {
        return Math.min(this.names.size(), this.data.size());
    }

    public void removeChartDataModelListener(ChartDataModelListener chartDataModelListener) {
        this.listener.remove(ChartDataModelListener.class, chartDataModelListener);
    }

    public void addChartDataModelListener(ChartDataModelListener chartDataModelListener) {
        this.listener.add(ChartDataModelListener.class, chartDataModelListener);
    }

    public void setAutoScale(boolean bl) {
        if (!bl) {
            this.setMaximumValueX(new Double(this.getMaxXValue()));
            this.setMinimumValueX(new Double(this.getMinXValue()));
            this.setMaximumValueY(new Double(this.getMaxYValue()));
            this.setMinimumValueY(new Double(this.getMinYValue()));
        }
        this.autoscale = bl;
    }

    public boolean isAutoScale() {
        return this.autoscale;
    }

    public void setManualScale(boolean bl) {
        this.setAutoScale(!bl);
    }

    public boolean isManualScale() {
        return !this.isAutoScale();
    }

    public void setMaximumColumnValue(double d) {
        this.manual_max_x = new Double(d);
    }

    public void setMinimumColumnValue(double d) {
        this.manual_min_x = new Double(d);
    }

    public void setMaximumValue(Number number) {
        this.manual_max_y = new Double(number.doubleValue());
    }

    public void setMinimumValue(Number number) {
        this.manual_min_y = new Double(number.doubleValue());
    }

    public double getManualMaximumColumnValue() {
        try {
            return this.manual_max_x;
        }
        catch (NullPointerException nullPointerException) {
            return Double.NaN;
        }
    }

    public double getManualMinimumColumnValue() {
        try {
            return this.manual_min_x;
        }
        catch (NullPointerException nullPointerException) {
            return Double.NaN;
        }
    }

    public Number getManualMaximumValue() {
        return this.manual_max_y;
    }

    public Number getManualMinimumValue() {
        return this.manual_min_y;
    }

    public Number getManualMinimumX() {
        return this.manual_min_x;
    }

    public Number getManualMaximumX() {
        return this.manual_max_x;
    }

    public Number getManualMinimumY() {
        return this.manual_min_y;
    }

    public Number getManualMaximumY() {
        return this.manual_max_y;
    }

    public void setMaximumValueX(Number number) {
        this.manual_max_x = number instanceof Double ? (Double)number : (number == null ? null : new Double(number.doubleValue()));
    }

    public void setMaximumValueY(Number number) {
        this.manual_max_y = number instanceof Double ? (Double)number : (number == null ? null : new Double(number.doubleValue()));
    }

    public void setMinimumValueX(Number number) {
        this.manual_min_x = number instanceof Double ? (Double)number : (number == null ? null : new Double(number.doubleValue()));
    }

    public void setMinimumValueY(Number number) {
        this.manual_min_y = number instanceof Double ? (Double)number : (number == null ? null : new Double(number.doubleValue()));
    }

    public boolean isColumnNumeric() {
        return true;
    }

    public int getDataSetLength(int n) {
        if (n > this.data.size()) {
            return -1;
        }
        return this.data.get(n).size();
    }

    public String getDataSetName(int n) {
        if (n > this.names.size()) {
            return null;
        }
        return this.names.get(n);
    }

    public int getDataSetIndex(String string) {
        for (int i = 0; i < this.names.size(); ++i) {
            if (this.names.get(i).compareTo(string) != 0) continue;
            return i;
        }
        return -1;
    }

    public Number getValueAt(int n, int n2) {
        if (n > this.data.size()) {
            return null;
        }
        return new Double(this.data.get(n).getY(n2));
    }

    public void setValueAt(int n, int n2, Object object) {
        if (n > this.data.size()) {
            return;
        }
        this.clearBuffers();
    }

    public Class getColumnClass() {
        return Number.class;
    }

    public Object getColumnValueAt(int n) {
        return null;
    }

    public Object getColumnValueAt(int n, int n2) {
        if (n > this.data.size()) {
            return null;
        }
        return new Double(this.data.get(n).getX(n2));
    }

    public int getDataSetNumber() {
        return this.getNumberSeries();
    }

    public int getAxisBinding(int n) {
        return 0;
    }

    public void setAxisBinding(int n, int n2) {
    }

    public ChartDataModelConstraints getChartDataModelConstraints(int n) {
        return this.constraints;
    }

    public void setChartDataModelConstraints(int n, ChartDataModelConstraints chartDataModelConstraints) {
        this.constraints = chartDataModelConstraints;
    }

    public double getMaxXValue() {
        if (this.max_x == null) {
            double d = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.data.size(); ++i) {
                double d2 = this.data.get(i).getMaxX();
                if (!(d2 > d)) continue;
                d = d2;
            }
            this.max_x = new Double(d);
            this.checkConstraintSafety();
        }
        return this.max_x;
    }

    public double getMaxYValue() {
        if (this.max_y == null) {
            double d = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.data.size(); ++i) {
                double d2 = this.data.get(i).getMaxY();
                if (!(d2 > d)) continue;
                d = d2;
            }
            this.max_y = new Double(d);
            this.checkConstraintSafety();
        }
        return this.max_y;
    }

    public double getMinXValue() {
        if (this.min_x == null) {
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.data.size(); ++i) {
                double d2 = this.data.get(i).getMinX();
                if (!(d2 < d)) continue;
                d = d2;
            }
            this.min_x = new Double(d);
            this.checkConstraintSafety();
        }
        return this.min_x;
    }

    public double getMinYValue() {
        if (this.min_y == null) {
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.data.size(); ++i) {
                double d2 = this.data.get(i).getMinY();
                if (!(d2 < d)) continue;
                d = d2;
            }
            this.min_y = new Double(d);
            this.checkConstraintSafety();
        }
        return this.min_y;
    }

    public void setSeriesMarker(String string, boolean bl) {
        int n;
        for (n = 0; n < this.getDataSetNumber() && string.compareTo(this.getDataSetName(n)) != 0; ++n) {
        }
        if (n < this.getDataSetNumber()) {
            SeriesProperties seriesProperties = this.properties.get(n);
            if (bl) {
                seriesProperties.setMarkerOn();
            } else {
                seriesProperties.setMarkerOff();
            }
        }
    }

    public void setSeriesLine(String string, boolean bl) {
        int n;
        for (n = 0; n < this.getDataSetNumber() && string.compareTo(this.getDataSetName(n)) != 0; ++n) {
        }
        if (n < this.getDataSetNumber()) {
            SeriesProperties seriesProperties = this.properties.get(n);
            if (bl) {
                seriesProperties.setLineOn();
            } else {
                seriesProperties.setLineOff();
            }
        }
    }

    public boolean getSeriesMarker(String string) {
        return this.getSeriesMarker(this.getDataSetIndex(string));
    }

    public boolean getSeriesMarker(int n) {
        if (n > this.properties.size() || n < 0) {
            return false;
        }
        SeriesProperties seriesProperties = this.properties.get(n);
        return seriesProperties.getMarker();
    }

    public boolean getSeriesLine(String string) {
        return this.getSeriesLine(this.getDataSetIndex(string));
    }

    public boolean getSeriesLine(int n) {
        if (n > this.properties.size() || n < 0) {
            return false;
        }
        SeriesProperties seriesProperties = this.properties.get(n);
        return seriesProperties.getLine();
    }

    public String getSeriesLineStyle(int n) {
        if (n > this.properties.size()) {
            return null;
        }
        SeriesProperties seriesProperties = this.properties.get(n);
        return seriesProperties.getLineStyle();
    }

    public void setSeriesLineStyle(String string, int n) {
        if (n > this.properties.size()) {
            return;
        }
        SeriesProperties seriesProperties = this.properties.get(n);
        seriesProperties.setLineStyle(string);
    }

    public void clearDataModel() {
        this.data.clear();
        this.names.clear();
        this.properties.clear();
        this.clearBuffers();
    }

    public void fireChartDataModelChangedEvent(Object object) {
        ChartDataModelEvent chartDataModelEvent = new ChartDataModelEvent(object);
        Object[] objectArray = this.listener.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChartDataModelListener.class) continue;
            ((ChartDataModelListener)objectArray[i + 1]).chartDataChanged(chartDataModelEvent);
        }
        this.clearBuffers();
    }

    private void clearBuffers() {
        this.max_x = null;
        this.max_y = null;
        this.min_x = null;
        this.min_y = null;
    }

    private void checkConstraintSafety() {
        Double d;
        if (this.getMaxXValue() <= this.getMinXValue()) {
            if (this.min_x.compareTo(this.max_x) == 0) {
                if (this.min_x == 0.0) {
                    this.min_x = new Double(-1.0);
                    this.max_x = new Double(1.0);
                } else {
                    this.min_x = new Double(0.9 * this.min_x);
                    this.max_x = new Double(1.1 * this.max_x);
                }
            }
            if (this.min_x.compareTo(this.max_x) > 0) {
                d = this.min_x;
                this.min_x = this.max_x;
                this.max_x = d;
            }
        }
        if (this.getMaxYValue() <= this.getMinYValue()) {
            if (this.min_y.compareTo(this.max_y) == 0) {
                if (this.min_y == 0.0) {
                    this.min_y = new Double(-1.0);
                    this.max_y = new Double(1.0);
                } else {
                    this.min_y = new Double(0.9 * this.min_y);
                    this.max_y = new Double(1.1 * this.max_y);
                }
            }
            if (this.min_y.compareTo(this.max_y) > 0) {
                d = this.min_y;
                this.min_y = this.max_x;
                this.max_y = d;
            }
        }
    }

    private class SeriesProperties {
        private boolean show_marker = false;
        private boolean show_line = true;
        private String line_description = SimpleStrokeDefs.getDefaultStrokeDescription();

        public void setLineStyle(String string) {
            this.line_description = string;
        }

        public String getLineStyle() {
            return this.line_description;
        }

        public void setMarkerOn() {
            this.show_marker = true;
        }

        public void setMarkerOff() {
            this.show_marker = false;
        }

        public void setLineOn() {
            this.show_line = true;
        }

        public void setLineOff() {
            this.show_line = false;
        }

        public boolean getMarker() {
            return this.show_marker;
        }

        public boolean getLine() {
            return this.show_line;
        }
    }

    private class DataSet {
        private ArrayList<Double> xvalues = new ArrayList();
        private ArrayList<Double> yvalues = new ArrayList();

        public DataSet() {
        }

        public DataSet(double[] dArray, double[] dArray2) {
            this();
            this.setXValues(dArray);
            this.setYValues(dArray2);
        }

        public DataSet(double[][] dArray) {
            this();
            this.setXYValues(dArray);
        }

        public int size() {
            return Math.min(this.xvalues.size(), this.yvalues.size());
        }

        public double getX(int n) {
            if (n > this.xvalues.size()) {
                return -1.0;
            }
            return this.xvalues.get(n);
        }

        public double getY(int n) {
            if (n > this.yvalues.size()) {
                return -1.0;
            }
            return this.yvalues.get(n);
        }

        public void setXValues(double[] dArray) {
            for (int i = 0; i < dArray.length; ++i) {
                this.xvalues.add(new Double(dArray[i]));
            }
        }

        public void setYValues(double[] dArray) {
            for (int i = 0; i < dArray.length; ++i) {
                this.yvalues.add(new Double(dArray[i]));
            }
        }

        public void setXYValues(double[][] dArray) {
            if (dArray[0].length < 2) {
                return;
            }
            for (int i = 0; i < dArray.length; ++i) {
                this.xvalues.add(new Double(dArray[i][0]));
                this.yvalues.add(new Double(dArray[i][1]));
            }
        }

        public void setXValue(double d, int n) {
            if (n > this.xvalues.size()) {
                return;
            }
            this.xvalues.set(n, new Double(d));
        }

        public void setYValue(double d, int n) {
            if (n > this.yvalues.size()) {
                return;
            }
            this.yvalues.set(n, new Double(d));
        }

        public double getMaxX() {
            double d = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.xvalues.size(); ++i) {
                if (!(this.xvalues.get(i) > d)) continue;
                d = this.xvalues.get(i);
            }
            return d;
        }

        public double getMaxY() {
            double d = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.yvalues.size(); ++i) {
                if (!(this.yvalues.get(i) > d)) continue;
                d = this.yvalues.get(i);
            }
            return d;
        }

        public double getMinX() {
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.xvalues.size(); ++i) {
                if (!(this.xvalues.get(i) < d)) continue;
                d = this.xvalues.get(i);
            }
            return d;
        }

        public double getMinY() {
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.yvalues.size(); ++i) {
                if (!(this.yvalues.get(i) < d)) continue;
                d = this.yvalues.get(i);
            }
            return d;
        }
    }
}

