/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.model.DataSet;
import com.approximatrix.charting.model.DefaultChartDataModelConstraints;
import com.approximatrix.charting.model.DefaultDataSet;
import java.util.HashMap;
import java.util.TreeSet;

public class ObjectChartDataModel
extends AbstractChartDataModel {
    protected Object[] columns;
    protected DataSet[] data;
    protected HashMap valuesbyaxis = new HashMap();
    protected ChartDataModelConstraints constraints1;
    protected ChartDataModelConstraints constraints2;

    public ObjectChartDataModel() {
        this.data = new DefaultDataSet[0];
        this.columns = new Object[0];
        TreeSet treeSet = new TreeSet();
        this.valuesbyaxis.put(new Integer(0), treeSet);
        TreeSet treeSet2 = new TreeSet();
        this.valuesbyaxis.put(new Integer(1), treeSet2);
        this.constraints1 = new DefaultChartDataModelConstraints(this, 0, false);
        this.constraints2 = new DefaultChartDataModelConstraints(this, 1, false);
    }

    public ObjectChartDataModel(Number[][] numberArray, Object[] objectArray, String[] stringArray) {
        this();
        this.columns = objectArray;
        this.data = new DefaultDataSet[numberArray.length];
        TreeSet treeSet = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(treeSet, numberArray);
        for (int i = 0; i < numberArray.length; ++i) {
            this.data[i] = new DefaultDataSet(numberArray[i], objectArray, 0, stringArray[i]);
        }
    }

    public ObjectChartDataModel(int[][] nArray, Object[] objectArray, String[] stringArray) {
        this();
        Number[][] numberArray = ChartUtilities.transformArray(nArray);
        this.columns = objectArray;
        this.data = new DefaultDataSet[nArray.length];
        TreeSet treeSet = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(treeSet, numberArray);
        for (int i = 0; i < nArray.length; ++i) {
            this.data[i] = new DefaultDataSet(numberArray[i], objectArray, 0, stringArray[i]);
        }
    }

    public ObjectChartDataModel(double[][] dArray, Object[] objectArray, String[] stringArray) {
        this();
        Number[][] numberArray = ChartUtilities.transformArray(dArray);
        this.columns = objectArray;
        this.data = new DefaultDataSet[dArray.length];
        TreeSet treeSet = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(treeSet, numberArray);
        for (int i = 0; i < dArray.length; ++i) {
            this.data[i] = new DefaultDataSet(numberArray[i], objectArray, 0, stringArray[i]);
        }
    }

    public ObjectChartDataModel(DataSet[] dataSetArray, Object[] objectArray) {
        this();
        this.data = dataSetArray;
        this.columns = objectArray;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < dataSetArray.length; ++i) {
            int n;
            hashMap.clear();
            Object[] objectArray2 = new Number[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                hashMap.put(objectArray[n], new Double(Double.NaN));
            }
            TreeSet treeSet = (TreeSet)this.valuesbyaxis.get(new Integer(dataSetArray[i].getYAxis()));
            for (n = 0; n < dataSetArray[i].getDataSetLength(); ++n) {
                hashMap.put(dataSetArray[i].getColumnValueAt(n), dataSetArray[i].getValueAt(n));
                treeSet.add(dataSetArray[i].getValueAt(n));
            }
            for (n = 0; n < objectArray.length; ++n) {
                objectArray2[n] = (Number)hashMap.get(objectArray[n]);
            }
            this.data[i] = new DefaultDataSet(objectArray2, objectArray, 0, dataSetArray[i].getTitle());
        }
    }

    public int getDataSetLength(int n) {
        return this.data[n].getDataSetLength();
    }

    public int getDataSetNumber() {
        return this.data.length;
    }

    public String getDataSetName(int n) {
        return this.data[n].getTitle();
    }

    public int getAxisBinding(int n) {
        return this.data[n].getYAxis();
    }

    public Number getValueAt(int n, int n2) {
        return (Number)this.data[n].getValueAt(n2);
    }

    public ChartDataModelConstraints getChartDataModelConstraints(int n) {
        if (n == 0) {
            return this.constraints1;
        }
        return this.constraints2;
    }

    public void setChartDataModelConstraints(int n, ChartDataModelConstraints chartDataModelConstraints) {
        if (n == 0) {
            this.constraints1 = chartDataModelConstraints;
        } else {
            this.constraints2 = chartDataModelConstraints;
        }
    }

    public Object getColumnValueAt(int n) {
        if (this.columns == null) {
            return null;
        }
        if (n < this.columns.length && n >= 0) {
            return this.columns[n];
        }
        return null;
    }

    public Object getColumnValueAt(int n, int n2) {
        return this.getColumnValueAt(n2);
    }

    protected TreeSet getOrderedValues(int n) {
        return (TreeSet)this.valuesbyaxis.get(new Integer(n));
    }

    protected double getFirstColumnValue() {
        return 0.0;
    }

    protected double getLastColumnValue() {
        return Math.max((double)this.columns.length, 1.0);
    }
}

