/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;

public class StackedChartDataModelConstraints
implements ChartDataModelConstraints {
    protected AbstractChartDataModel model;
    protected int axis;
    protected boolean allowManualColScale = true;

    public StackedChartDataModelConstraints(AbstractChartDataModel abstractChartDataModel, int n) {
        this.model = abstractChartDataModel;
        this.axis = n;
    }

    public StackedChartDataModelConstraints(AbstractChartDataModel abstractChartDataModel, int n, boolean bl) {
        this(abstractChartDataModel, n);
        this.allowManualColScale = bl;
    }

    public Number getMaximumValue() {
        return this.getMaximumY();
    }

    public Number getMaximumY() {
        int n = Integer.MAX_VALUE;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        for (int i = 0; i < this.model.getDataSetNumber(); ++i) {
            n = Math.min(n, this.model.getDataSetLength(i));
        }
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.model.getDataSetNumber(); ++j) {
                d5 = this.model.getValueAt(j, i).doubleValue();
                if (d5 < 0.0) {
                    d3 += d5;
                    continue;
                }
                d4 += d5;
            }
            d2 = Math.min(d3, d2);
            d3 = 0.0;
            d = Math.max(d4, d);
            d4 = 0.0;
        }
        if (this.model.getOrderedValues(0).size() == 0 || d == 0.0 && d2 == 0.0) {
            return new Integer(1);
        }
        if (this.model.isManualScale()) {
            return new Double(Math.max(this.model.getManualMaximumValue().doubleValue(), d));
        }
        if (this.model.isAutoScale()) {
            if (d2 / d > 0.95) {
                return new Double(ChartUtilities.performAutoScale(d2 / 2.0, 2.0 * d)[1]);
            }
            return new Double(ChartUtilities.performAutoScale(d2, d)[1]);
        }
        return new Double(d);
    }

    public Number getMinimumValue() {
        return this.getMinimumY();
    }

    public Number getMinimumY() {
        int n = Integer.MAX_VALUE;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.model.getDataSetNumber(); ++i) {
            n = Math.min(n, this.model.getDataSetLength(i));
        }
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.model.getDataSetNumber(); ++j) {
                d5 = this.model.getValueAt(j, i).doubleValue();
                if (d5 < 0.0) {
                    d4 += d5;
                    continue;
                }
                d3 += d5;
            }
            d2 = Math.min(d4, d2);
            d4 = 0.0;
            d = Math.max(d3, d);
            d3 = 0.0;
        }
        if (this.model.getOrderedValues(0).size() == 0 || d == 0.0 && d2 == 0.0) {
            return new Integer(0);
        }
        if (this.model.isManualScale()) {
            return new Double(Math.min(this.model.getManualMinimumValue().doubleValue(), d2));
        }
        if (this.model.isAutoScale()) {
            if (d2 / d > 0.95) {
                return new Double(ChartUtilities.performAutoScale(d2 / 2.0, 2.0 * d)[0]);
            }
            return new Double(ChartUtilities.performAutoScale(d2, d)[0]);
        }
        return new Double(d2);
    }

    public double getMinimumColumnValue() {
        Number number = this.getMinimumX();
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public Number getMinimumX() {
        if (this.model.isManualScale() && this.allowManualColScale) {
            return this.model.getManualMinimumX();
        }
        if (this.model.isAutoScale()) {
            return new Double(ChartUtilities.performAutoScale(this.model.getFirstColumnValue(), this.model.getLastColumnValue())[0]);
        }
        return new Double(this.model.getFirstColumnValue());
    }

    public double getMaximumColumnValue() {
        Number number = this.getMaximumX();
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public Number getMaximumX() {
        if (this.model.isManualScale() && this.allowManualColScale) {
            return this.model.getManualMaximumX();
        }
        if (this.model.isAutoScale()) {
            return new Double(ChartUtilities.performAutoScale(this.model.getFirstColumnValue(), this.model.getLastColumnValue())[1]);
        }
        return new Double(this.model.getLastColumnValue());
    }
}

