/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model.threedimensional;

import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.model.IntegratedImageModel;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;

public abstract class AbstractDotPlotDataModel
extends AbstractChartDataModel
implements IntegratedImageModel {
    protected BufferedImage dataImage = null;
    protected double minX = 0.0;
    protected double maxX = 0.0;
    protected double minY = 0.0;
    protected double maxY = 0.0;
    protected ChartDataModelConstraints constraints = null;

    protected AbstractDotPlotDataModel() {
        this.autoscale = true;
    }

    public BufferedImage getImage() {
        return this.dataImage;
    }

    public Image getViewableImage() {
        Object object;
        AffineTransform affineTransform;
        if (this.dataImage == null) {
            this.buildImage();
        }
        if (this.autoscale) {
            return this.dataImage;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = this.getXIndex(this.minX);
        int n2 = this.getXIndex(this.maxX);
        int n3 = this.getYIndex(this.minY);
        int n4 = this.getYIndex(this.maxY);
        try {
            n = this.getXIndex(this.getManualMinimumX().doubleValue());
            n2 = this.getXIndex(this.getManualMaximumX().doubleValue());
            n3 = this.getYIndex(this.getManualMinimumY().doubleValue());
            n4 = this.getYIndex(this.getManualMaximumY().doubleValue());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ++n3;
        ++n4;
        if (n2 < n) {
            bl = true;
            n = this.dataImage.getWidth() - n;
            n2 = this.dataImage.getWidth() - n2;
        }
        if (n3 < n4) {
            bl2 = true;
            n3 = this.dataImage.getHeight() - n3;
            n4 = this.dataImage.getHeight() - n4;
        }
        Object object2 = this.dataImage;
        if (bl) {
            affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
            affineTransform.translate(-((BufferedImage)object2).getWidth(null), 0.0);
            object = new AffineTransformOp(affineTransform, 1);
            object2 = ((AffineTransformOp)object).filter((BufferedImage)object2, null);
        }
        if (bl2) {
            affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
            affineTransform.translate(0.0, -((BufferedImage)object2).getHeight(null));
            object = new AffineTransformOp(affineTransform, 1);
            object2 = ((AffineTransformOp)object).filter((BufferedImage)object2, null);
        }
        try {
            object2 = ((BufferedImage)object2).getSubimage(n, n4, Math.abs(n2 - n), Math.abs(n4 - n3));
        }
        catch (RasterFormatException rasterFormatException) {
            object = new BufferedImage(Math.abs(n2 - n), Math.abs(n4 - n3), this.dataImage.getType());
            Graphics graphics = ((BufferedImage)object).getGraphics();
            try {
                int n5 = Math.max(0, n);
                int n6 = Math.max(0, n4);
                int n7 = Math.abs(n5 - Math.min(n2, ((BufferedImage)object2).getWidth()));
                int n8 = Math.abs(n6 - Math.min(n3, ((BufferedImage)object2).getHeight()));
                BufferedImage bufferedImage = ((BufferedImage)object2).getSubimage(n5, n6, n7, n8);
                graphics.drawImage(bufferedImage, Math.abs(Math.min(n, 0)), Math.abs(Math.min(n4, 0)), null);
                object2 = object;
            }
            catch (RasterFormatException rasterFormatException2) {
                System.err.println("Error in AbstractDotPlotDataModel");
                rasterFormatException2.printStackTrace();
                object2 = null;
            }
        }
        return object2;
    }

    public int getXIndex(double d) {
        double[] dArray = new double[]{d};
        return this.getXIndices(dArray)[0];
    }

    public int getYIndex(double d) {
        double[] dArray = new double[]{d};
        return this.getYIndices(dArray)[0];
    }

    private int getIndex(double d, double d2, double d3, int n) {
        double d4 = d3 - d2;
        if (d4 == 0.0) {
            return 0;
        }
        return (int)(d / d4 * (double)n);
    }

    public int[] getXIndices(double[] dArray) {
        return this.getIndices(dArray, this.minX, this.maxX, this.dataImage.getWidth());
    }

    public int[] getYIndices(double[] dArray) {
        return this.getIndices(dArray, this.maxY, this.minY, this.dataImage.getHeight());
    }

    private int[] getIndices(double[] dArray, double d, double d2, int n) throws NullPointerException {
        if (dArray == null) {
            throw new NullPointerException();
        }
        double d3 = d2 - d;
        if (d3 == 0.0) {
            return null;
        }
        double d4 = (double)n / d3;
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d5 = (dArray[i] - d) * d4;
            nArray[i] = d5 < 0.0 ? (int)Math.ceil(d5) : (int)Math.floor(d5);
        }
        return nArray;
    }

    protected void scanRanges(double[] dArray, double[] dArray2) {
        this.maxX = Double.MIN_VALUE;
        this.minX = Double.MAX_VALUE;
        this.maxY = Double.MIN_VALUE;
        this.minY = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length && i < dArray2.length; ++i) {
            this.maxX = Math.max(this.maxX, dArray[i]);
            this.minX = Math.min(this.minX, dArray[i]);
            this.maxY = Math.max(this.maxY, dArray2[i]);
            this.minY = Math.min(this.minY, dArray2[i]);
        }
    }

    protected void initializeImage(int n, int n2) {
        this.dataImage = new BufferedImage(n, n2, 2);
    }

    protected abstract void buildImage();

    public void setChartDataModelConstraints(int n, ChartDataModelConstraints chartDataModelConstraints) {
        if (n == 0) {
            this.constraints = chartDataModelConstraints;
        }
    }

    public ChartDataModelConstraints getChartDataModelConstraints(int n) {
        if (n == 0) {
            return this.constraints;
        }
        return null;
    }

    public double getModelMaximumX() {
        return this.maxX;
    }

    public double getModelMinimumX() {
        return this.minX;
    }

    public double getModelMaximumY() {
        return this.maxY;
    }

    public double getModelMinimumY() {
        return this.minY;
    }

    public boolean isColumnNumeric() {
        return true;
    }
}

