/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model.threedimensional;

import com.approximatrix.charting.model.threedimensional.AbstractDotPlotDataModel;
import com.approximatrix.charting.model.threedimensional.DotPlotDataModelConstraints;
import java.awt.Color;
import java.util.TreeSet;

public class ColorDotPlotDataModel
extends AbstractDotPlotDataModel {
    private static final int DEFAULT_WIDTH = 500;
    private static final int DEFAULT_HEIGHT = 500;
    private int w = 500;
    private int h = 500;
    protected double[] x = null;
    protected double[] y = null;
    protected Color[] c = null;

    public ColorDotPlotDataModel() {
    }

    public ColorDotPlotDataModel(int[] nArray, int[] nArray2, Color[] colorArray) {
        if (nArray == null || nArray2 == null || colorArray == null) {
            throw new NullPointerException();
        }
        int n = Math.min(nArray.length, Math.min(nArray2.length, colorArray.length));
        this.x = new double[n];
        this.y = new double[n];
        this.c = colorArray;
        for (int i = 0; i < n; ++i) {
            this.x[i] = nArray[i];
            this.y[i] = nArray2[i];
        }
        this.initialize();
    }

    public ColorDotPlotDataModel(double[] dArray, double[] dArray2, Color[] colorArray) throws NullPointerException {
        if (dArray == null || dArray2 == null || colorArray == null) {
            throw new NullPointerException();
        }
        this.x = dArray;
        this.y = dArray2;
        this.c = colorArray;
        this.initialize();
    }

    private void initialize() {
        this.scanRanges(this.x, this.y);
        this.constraints = new DotPlotDataModelConstraints(this, 0);
    }

    public void setResolution(int n, int n2) {
        if (n != this.w || n2 != this.h) {
            this.dataImage = null;
        }
        this.w = n;
        this.h = n2;
        this.fireChartDataModelChangedEvent(this);
    }

    protected void buildImage() {
        this.initializeImage(this.w, this.h);
        int n = this.getDataSetLength(0);
        int[] nArray = super.getXIndices(this.x);
        int[] nArray2 = super.getYIndices(this.y);
        for (int i = 0; i < n; ++i) {
            try {
                this.dataImage.setRGB(nArray[i], nArray2[i], this.c[i].getRGB());
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    protected double getFirstColumnValue() {
        return this.minX;
    }

    protected double getLastColumnValue() {
        return this.maxX;
    }

    protected TreeSet getOrderedValues(int n) {
        return null;
    }

    public Object getColumnValueAt(int n) {
        return this.x[n];
    }

    public Object getColumnValueAt(int n, int n2) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Set 0 is the only valid data set");
        }
        return this.x[n2];
    }

    public int getDataSetLength(int n) throws IndexOutOfBoundsException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Set 0 is the only valid data set");
        }
        return Math.min(this.x.length, Math.min(this.y.length, this.c.length));
    }

    public int getDataSetNumber() {
        if (this.x == null || this.y == null || this.c == null) {
            return 0;
        }
        return 1;
    }

    public Number getValueAt(int n, int n2) throws IndexOutOfBoundsException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Set 0 is the only valid data set");
        }
        return new Integer(this.c[n2].getRGB());
    }

    public void setValueAt(int n, int n2, Color color) {
        this.setValueAt((double)n, (double)n2, color);
    }

    public void setValueAt(double d, double d2, Color color) {
        int n = this.getDataSetLength(0);
        double[] dArray = new double[n + 1];
        double[] dArray2 = new double[n + 1];
        Color[] colorArray = new Color[n + 1];
        dArray[n] = d;
        dArray2[n] = d2;
        colorArray[n] = color;
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.x[i];
            dArray2[i] = this.y[i];
            colorArray[i] = this.c[i];
        }
        this.x = dArray;
        this.y = dArray2;
        this.c = colorArray;
        this.dataImage = null;
        this.maxX = Math.max(d, this.maxX);
        this.maxY = Math.max(d2, this.maxY);
        this.minX = Math.min(d, this.minX);
        this.minY = Math.min(d2, this.minY);
    }
}

