/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.Renderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.event.EventListenerList;

public abstract class AbstractChartRenderer
implements Renderer {
    protected Rectangle bounds;
    protected CoordSystem coord;
    protected ChartDataModel model;
    protected RowColorModel rcm;
    private volatile boolean stopFlag = false;
    protected EventListenerList listener = new EventListenerList();

    protected AbstractChartRenderer(ChartDataModel chartDataModel) {
        this.model = chartDataModel;
    }

    public AbstractChartRenderer(CoordSystem coordSystem, ChartDataModel chartDataModel) {
        this(chartDataModel);
        this.coord = coordSystem;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Dimension getPreferredSize() {
        return new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void render(Graphics2D graphics2D) {
        Rectangle rectangle = this.getBounds();
        Shape shape = graphics2D.getClip();
        graphics2D.setClip((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        this.renderChart(graphics2D);
        graphics2D.setClip(shape);
    }

    public abstract boolean renderChart(Graphics2D var1);

    public void setBounds(Rectangle rectangle) {
        if (!rectangle.equals(this.bounds)) {
            this.bounds = rectangle;
            this.fireRenderChangeEvent();
        }
    }

    public void setChartDataModel(ChartDataModel chartDataModel) {
        this.model = chartDataModel;
        this.fireRenderChangeEvent();
    }

    public ChartDataModel getChartDataModel() {
        return this.model;
    }

    public CoordSystem getCoordSystem() {
        return this.coord;
    }

    public void setCoordSystem(CoordSystem coordSystem) {
        this.coord = coordSystem;
        this.fireRenderChangeEvent();
    }

    public AffineTransform getTransform(int n) {
        return this.getCoordSystem().getTransform(n);
    }

    public void setRowColorModel(RowColorModel rowColorModel) {
        this.rcm = rowColorModel;
        this.fireRenderChangeEvent();
    }

    public RowColorModel getRowColorModel() {
        return this.rcm;
    }

    public void fireRenderChangeEvent() {
        RenderChangeEvent renderChangeEvent = new RenderChangeEvent(this);
        Object[] objectArray = this.listener.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RenderChangeListener.class) continue;
            ((RenderChangeListener)objectArray[i + 1]).renderUpdateRequested(renderChangeEvent);
        }
    }

    public void removeRenderChangeListener(RenderChangeListener renderChangeListener) {
        this.listener.remove(RenderChangeListener.class, renderChangeListener);
    }

    public void addRenderChangeListener(RenderChangeListener renderChangeListener) {
        Object[] objectArray = this.listener.getListenerList();
        boolean bl = false;
        for (int i = objectArray.length - 1; i >= 1; i -= 2) {
            if (objectArray[i] != renderChangeListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.listener.add(RenderChangeListener.class, renderChangeListener);
        }
    }

    public void clearRenderChangeListeners() {
        this.listener = new EventListenerList();
    }

    public void interruptRendering() {
        this.setStopFlag(true);
    }

    public void resetStopFlag() {
        this.setStopFlag(false);
    }

    protected synchronized void setStopFlag(boolean bl) {
        this.stopFlag = bl;
    }

    protected synchronized boolean getStopFlag() {
        return this.stopFlag;
    }
}

