/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.render.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.event.EventListenerList;

public abstract class AbstractRenderer
implements Renderer {
    private static boolean DirectRender = true;
    protected EventListenerList listener = new EventListenerList();
    Rectangle bounds = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public static void setDirectRender(boolean bl) {
        DirectRender = bl;
    }

    public static boolean getDirectRender() {
        return DirectRender;
    }

    public void setBounds(Rectangle rectangle) {
        if (this.isDifferentBounds(rectangle)) {
            this.bounds = rectangle;
            this.fireRenderChangeEvent();
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    private void directRender(Graphics2D graphics2D) {
        graphics2D.translate(this.getBounds().x, this.getBounds().y);
        this.paintDefault(graphics2D);
        graphics2D.translate(-this.getBounds().x, -this.getBounds().y);
    }

    public void render(Graphics2D graphics2D) {
        if (DirectRender) {
            this.directRender(graphics2D);
        } else {
            Dimension dimension = this.getPreferredSize();
            if (dimension.width <= 0 || (double)dimension.width > 100000.0) {
                dimension.width = 1;
            }
            if (dimension.height <= 0 || (double)dimension.height > 100000.0) {
                dimension.height = 1;
            }
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.setColor(Color.white);
            graphics2D2.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D2.setColor(Color.black);
            this.paintDefault(graphics2D2);
            if ((double)dimension.width > this.getBounds().getWidth() || (double)dimension.height > this.getBounds().getHeight()) {
                Image image = bufferedImage.getScaledInstance((int)this.getBounds().getWidth(), (int)this.getBounds().getHeight(), 4);
                graphics2D.drawImage(image, (int)this.getBounds().getX(), (int)this.getBounds().getY(), null);
            } else {
                graphics2D.drawImage((Image)bufferedImage, (int)this.getBounds().getX(), (int)this.getBounds().getY(), null);
            }
        }
    }

    public abstract void paintDefault(Graphics2D var1);

    public void fireRenderChangeEvent() {
        RenderChangeEvent renderChangeEvent = new RenderChangeEvent(this);
        Object[] objectArray = this.listener.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RenderChangeListener.class) continue;
            ((RenderChangeListener)objectArray[i + 1]).renderUpdateRequested(renderChangeEvent);
        }
    }

    public void removeRenderChangeListener(RenderChangeListener renderChangeListener) {
        this.listener.remove(RenderChangeListener.class, renderChangeListener);
    }

    public void addRenderChangeListener(RenderChangeListener renderChangeListener) {
        Object[] objectArray = this.listener.getListenerList();
        boolean bl = false;
        for (int i = objectArray.length - 1; i >= 1; i -= 2) {
            if (objectArray[i] != renderChangeListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.listener.add(RenderChangeListener.class, renderChangeListener);
        }
    }

    public void clearRenderChangeListeners() {
        this.listener = new EventListenerList();
    }

    protected boolean isDifferentBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getBounds();
        if (rectangle2 == rectangle) {
            return false;
        }
        return !rectangle2.equals(rectangle);
    }
}

