/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class BarChartRenderer
extends AbstractChartRenderer {
    protected DecimalFormat barTopFormat;
    protected float boxWidth = 1.0f;
    protected Font barTopFont;

    public BarChartRenderer(CoordSystem coordSystem, ChartDataModel chartDataModel) {
        super(coordSystem, chartDataModel);
    }

    public BarChartRenderer(CoordSystem coordSystem, ChartDataModel chartDataModel, DecimalFormat decimalFormat, Font font, float f) {
        super(coordSystem, chartDataModel);
        this.barTopFormat = decimalFormat;
        this.barTopFont = font;
        this.boxWidth = f;
    }

    public boolean renderChart(Graphics2D graphics2D) {
        int n;
        ChartDataModel chartDataModel = this.getChartDataModel();
        ChartDataModelConstraints chartDataModelConstraints = chartDataModel.getChartDataModelConstraints(0);
        if (chartDataModel.isColumnNumeric()) {
            return false;
        }
        RowColorModel rowColorModel = this.getRowColorModel();
        AffineTransform affineTransform = this.getTransform(0);
        AffineTransform affineTransform2 = this.getTransform(1);
        int n2 = chartDataModel.getDataSetNumber();
        Point2D point2D = affineTransform.transform(new Point2D.Float(chartDataModelConstraints.getMinimumX().floatValue(), chartDataModelConstraints.getMaximumY().floatValue()), null);
        Point2D point2D2 = affineTransform.transform(new Point2D.Float(chartDataModelConstraints.getMaximumX().floatValue(), chartDataModelConstraints.getMaximumY().floatValue()), null);
        Point2D point2D3 = point2D;
        int n3 = 1;
        if (chartDataModelConstraints.getMaximumX().intValue() != 0) {
            n3 = (int)((point2D2.getX() - point2D.getX()) / Math.abs(chartDataModelConstraints.getMaximumX().doubleValue()));
        } else if (chartDataModelConstraints.getMinimumX().intValue() != 0) {
            n3 = (int)((point2D2.getX() - point2D.getX()) / Math.abs(chartDataModelConstraints.getMinimumX().doubleValue()));
        }
        int n4 = (int)((float)n3 * this.boxWidth / (float)n2);
        float f = (float)((double)n3 * ((1.0 - (double)this.boxWidth) / 2.0));
        Point2D point2D4 = chartDataModelConstraints.getMinimumY().floatValue() > 0.0f ? affineTransform.transform(new Point2D.Float(chartDataModelConstraints.getMinimumX().floatValue(), chartDataModelConstraints.getMinimumY().floatValue()), null) : (chartDataModelConstraints.getMaximumY().floatValue() < 0.0f ? affineTransform.transform(new Point2D.Float(chartDataModelConstraints.getMinimumX().floatValue(), chartDataModelConstraints.getMaximumY().floatValue()), null) : affineTransform.transform(new Point2D.Float(chartDataModelConstraints.getMinimumX().floatValue(), 0.0f), null));
        FontRenderContext fontRenderContext = null;
        LineMetrics lineMetrics = null;
        Object var17_17 = null;
        Rectangle2D rectangle2D = null;
        String string = null;
        if (this.barTopFormat != null) {
            graphics2D.setFont(this.barTopFont);
            fontRenderContext = new FontRenderContext(null, false, false);
        }
        for (n = 0; n < n2 && !this.getStopFlag(); ++n) {
            for (int i = 0; i < chartDataModel.getDataSetLength(n) && !this.getStopFlag(); ++i) {
                affineTransform.transform(new Point2D.Float(i, chartDataModel.getValueAt(n, i).floatValue()), point2D3);
                Rectangle2D.Float float_ = new Rectangle2D.Float((float)(point2D3.getX() + (double)f + (double)(n * n4)), (float)Math.min(point2D3.getY(), point2D4.getY()), n4, (float)Math.abs(point2D4.getY() - point2D3.getY()));
                graphics2D.setColor(rowColorModel.getColor(n));
                graphics2D.fill(float_);
                graphics2D.setColor(Color.black);
                graphics2D.draw(float_);
                if (this.barTopFormat == null) continue;
                string = this.barTopFormat.format(this.model.getValueAt(n, i).doubleValue());
                rectangle2D = this.barTopFont.getStringBounds(string, fontRenderContext);
                lineMetrics = this.barTopFont.getLineMetrics(string, fontRenderContext);
                graphics2D.drawString(string, (float)(point2D3.getX() + (double)(n * n4) + ((double)n4 - rectangle2D.getWidth()) / 2.0) - lineMetrics.getLeading(), (float)(Math.min(point2D3.getY(), point2D4.getY()) - (double)lineMetrics.getDescent()));
            }
        }
        n = !this.getStopFlag() ? 1 : 0;
        this.resetStopFlag();
        return n != 0;
    }
}

