/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.IntegratedImageModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

public class ImageRenderer
extends AbstractChartRenderer {
    private AffineTransform last = null;
    private Image renderImage = null;
    private IntegratedImageModel dpmodel = null;
    private int scaleHints = 2;

    public ImageRenderer(CoordSystem coordSystem, IntegratedImageModel integratedImageModel) {
        super(coordSystem, integratedImageModel);
        this.coord = coordSystem;
        this.model = integratedImageModel;
        this.dpmodel = integratedImageModel;
        this.renderImage = null;
    }

    public boolean renderChart(Graphics2D graphics2D) {
        if (this.last != this.coord.getTransform(0) || this.renderImage == null) {
            try {
                this.renderImage = this.dpmodel.getViewableImage();
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("Error in scaling/displaying image...");
                nullPointerException.printStackTrace();
                return false;
            }
        }
        Rectangle rectangle = this.coord.getInnerBounds();
        graphics2D.drawImage(this.renderImage.getScaledInstance(rectangle.width, rectangle.height, this.scaleHints), rectangle.x, rectangle.y, null);
        return true;
    }

    public void setScaleHint(int n) {
        this.scaleHints = n;
    }
}

