/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class InterpolationChartRenderer
extends AbstractChartRenderer {
    public InterpolationChartRenderer(CoordSystem coordSystem, ChartDataModel chartDataModel) {
        super(coordSystem, chartDataModel);
    }

    public boolean renderChart(Graphics2D graphics2D) {
        int n;
        ChartDataModel chartDataModel = this.getChartDataModel();
        RowColorModel rowColorModel = this.getRowColorModel();
        AffineTransform affineTransform = this.getTransform(0);
        int n2 = chartDataModel.getDataSetNumber();
        Point2D point2D = null;
        Point2D point2D2 = null;
        if (!chartDataModel.isColumnNumeric()) {
            return false;
        }
        for (n = 0; n < n2 && !this.getStopFlag(); ++n) {
            int n3;
            int n4;
            double[] dArray = new double[chartDataModel.getDataSetLength(n)];
            double[] dArray2 = new double[dArray.length];
            for (n4 = 0; n4 < chartDataModel.getDataSetLength(n); ++n4) {
                dArray[n4] = ((Number)chartDataModel.getColumnValueAt(n, n4)).doubleValue();
                if (dArray[n4] != dArray[n4]) {
                    dArray[n4] = 0.0;
                }
                dArray2[n4] = chartDataModel.getValueAt(n, n4).doubleValue();
                if (!this.getStopFlag()) continue;
                this.resetStopFlag();
                return false;
            }
            n4 = 2000;
            double d = chartDataModel.getChartDataModelConstraints(0).getMinimumColumnValue();
            double d2 = chartDataModel.getChartDataModelConstraints(0).getMaximumColumnValue();
            double[] dArray3 = new double[n4];
            double[] dArray4 = new double[n4];
            for (n3 = 0; n3 < n4 && !this.getStopFlag(); ++n3) {
                dArray3[n3] = d + (double)n3 * (Math.abs(d2 - d) / (double)n4);
                dArray4[n3] = ChartUtilities.interpolate(dArray, dArray2, dArray3[n3]);
            }
            for (n3 = 0; n3 < n4 && !this.getStopFlag(); ++n3) {
                Point2D.Double double_ = new Point2D.Double(dArray3[n3], dArray4[n3]);
                point2D2 = point2D;
                if (affineTransform.transform(double_, null) == null) continue;
                point2D = affineTransform.transform(double_, point2D);
                graphics2D.setColor(rowColorModel.getColor(n));
                if (point2D2 == null) continue;
                graphics2D.drawLine((int)point2D2.getX(), (int)point2D2.getY(), (int)point2D.getX(), (int)point2D.getY());
            }
            point2D2 = null;
            point2D = null;
        }
        n = !this.getStopFlag() ? 1 : 0;
        this.resetStopFlag();
        return n != 0;
    }
}

