/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.SimpleStrokeDefs;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.MultiScatterDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;

public class MultiScatterChartRenderer
extends AbstractChartRenderer {
    protected Rectangle bounds;
    protected CoordSystem coord;
    protected MultiScatterDataModel model;
    protected RowColorModel rcm;
    protected double shapeSize = 10.0;
    private AffineTransform last = null;
    private ArrayList transformed = null;
    private boolean buffer_transform = false;

    public MultiScatterChartRenderer(CoordSystem coordSystem, MultiScatterDataModel multiScatterDataModel) {
        super(coordSystem, multiScatterDataModel);
        this.coord = coordSystem;
        this.model = multiScatterDataModel;
        this.last = new AffineTransform();
    }

    public boolean renderChart(Graphics2D graphics2D) {
        int n;
        if (this.getStopFlag()) {
            return false;
        }
        AffineTransform affineTransform = this.getTransform(0);
        int n2 = this.model.getDataSetNumber();
        if (this.transformed == null && this.buffer_transform) {
            this.transformed = new ArrayList(n2);
        }
        for (n = 0; n < n2 && !this.getStopFlag(); ++n) {
            if (this.transformed != null && this.transformed.size() < n2 && this.buffer_transform) {
                this.transformed.add(new Point2D[this.model.getDataSetLength(n)]);
            }
            if (this.model.getSeriesLine(n) && !this.getStopFlag()) {
                this.drawline(affineTransform, n, graphics2D);
            }
            if (!this.model.getSeriesMarker(n) || this.getStopFlag()) continue;
            this.drawmarkers(affineTransform, n, graphics2D);
        }
        if (this.buffer_transform && !this.getStopFlag() && !affineTransform.equals(this.last)) {
            this.last = affineTransform;
        }
        n = !this.getStopFlag() ? 1 : 0;
        this.resetStopFlag();
        return n != 0;
    }

    private void drawline(AffineTransform affineTransform, int n, Graphics2D graphics2D) {
        int n2;
        Point2D point2D = null;
        Point2D point2D2 = null;
        Point2D point2D3 = null;
        boolean bl = this.model.isColumnNumeric();
        float f = 0.0f;
        Point2D[] point2DArray = null;
        if (this.buffer_transform) {
            point2DArray = (Point2D[])this.transformed.get(n);
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(SimpleStrokeDefs.getStroke(this.model.getSeriesLineStyle(n)));
        graphics2D.setColor(this.rcm.getColor(n));
        if (!affineTransform.equals(this.last) || !this.buffer_transform) {
            for (n2 = 0; n2 < this.model.getDataSetLength(n); ++n2) {
                f = this.model.getValueAt(n, n2).floatValue();
                if (f != f || f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY) {
                    point2D3 = null;
                    continue;
                }
                Point2D.Float float_ = bl ? new Point2D.Float(((Number)this.model.getColumnValueAt(n, n2)).floatValue(), f) : new Point2D.Float(n2, f);
                point2D3 = point2D;
                point2D2 = affineTransform.transform(float_, null);
                if (point2D2 == null) continue;
                point2D = point2D2;
                point2D2 = null;
                if (!this.buffer_transform) {
                    if (point2D3 == null) continue;
                    graphics2D.drawLine((int)point2D3.getX(), (int)point2D3.getY(), (int)point2D.getX(), (int)point2D.getY());
                    continue;
                }
                point2DArray[n2] = point2D;
            }
        }
        if (this.buffer_transform && !this.getStopFlag()) {
            for (n2 = 1; n2 < this.model.getDataSetLength(n) && this.buffer_transform && !this.getStopFlag(); ++n2) {
                if (point2DArray[n2] == null || point2DArray[n2 - 1] == null) continue;
                graphics2D.drawLine((int)point2DArray[n2 - 1].getX(), (int)point2DArray[n2 - 1].getY(), (int)point2DArray[n2].getX(), (int)point2DArray[n2].getY());
            }
        }
        graphics2D.setStroke(stroke);
    }

    private void drawmarkers(AffineTransform affineTransform, int n, Graphics2D graphics2D) {
        RectangularShape rectangularShape;
        int n2;
        Point2D point2D = new Point2D.Float(0.0f, 0.0f);
        boolean bl = this.model.isColumnNumeric();
        float f = 0.0f;
        Point2D[] point2DArray = null;
        if (this.buffer_transform) {
            point2DArray = (Point2D[])this.transformed.get(n);
        }
        graphics2D.setColor(this.rcm.getColor(n));
        if (!affineTransform.equals(this.last) || !this.buffer_transform) {
            for (n2 = 0; n2 < this.model.getDataSetLength(n); ++n2) {
                Point2D.Float float_;
                f = this.model.getValueAt(n, n2).floatValue();
                if (Float.isNaN(f) || (point2D = affineTransform.transform(float_ = bl ? new Point2D.Float(((Number)this.model.getColumnValueAt(n, n2)).floatValue(), f) : new Point2D.Float(n2, f), null)) == null) continue;
                if (!this.buffer_transform) {
                    rectangularShape = this.rcm.getShape(n);
                    rectangularShape.setFrame(point2D.getX() - this.shapeSize / 2.0, point2D.getY() - this.shapeSize / 2.0, this.shapeSize, this.shapeSize);
                    graphics2D.fill(rectangularShape);
                } else {
                    point2DArray[n2] = point2D;
                }
                if (this.getStopFlag()) break;
            }
        }
        if (this.buffer_transform && !this.getStopFlag()) {
            for (n2 = 0; n2 < this.model.getDataSetLength(n) && this.buffer_transform; ++n2) {
                if (point2DArray[n2] == null) continue;
                rectangularShape = this.rcm.getShape(n);
                rectangularShape.setFrame(point2DArray[n2].getX() - this.shapeSize / 2.0, point2DArray[n2].getY() - this.shapeSize / 2.0, this.shapeSize, this.shapeSize);
                graphics2D.fill(rectangularShape);
                if (this.getStopFlag()) break;
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void setBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setChartDataModel(ChartDataModel chartDataModel) {
        this.model = (MultiScatterDataModel)chartDataModel;
    }

    public ChartDataModel getChartDataModel() {
        return this.model;
    }

    public CoordSystem getCoordSystem() {
        return this.coord;
    }

    public void setCoordSystem(CoordSystem coordSystem) {
        this.coord = coordSystem;
    }

    public AffineTransform getTransform(int n) {
        return this.getCoordSystem().getTransform(n);
    }

    public void setRowColorModel(RowColorModel rowColorModel) {
        this.rcm = rowColorModel;
    }

    public RowColorModel getRowColorModel() {
        return this.rcm;
    }

    public void fireDataUpdate() {
        this.last = null;
        this.transformed = null;
    }

    public void setAllowBuffer(boolean bl) {
        this.buffer_transform = bl;
    }
}

