/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;

public class PieChartRenderer
extends AbstractChartRenderer {
    public PieChartRenderer(ChartDataModel chartDataModel) {
        super(chartDataModel);
    }

    public PieChartRenderer(CoordSystem coordSystem, ChartDataModel chartDataModel) {
        super(coordSystem, chartDataModel);
    }

    public boolean renderChart(Graphics2D graphics2D) {
        int n;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartDataModel chartDataModel = this.getChartDataModel();
        RowColorModel rowColorModel = this.getRowColorModel();
        double d = this.getBounds().getHeight();
        double d2 = this.getBounds().getWidth();
        int n2 = chartDataModel.getDataSetNumber();
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < n2; ++i) {
            n3 = Math.min(n3, chartDataModel.getDataSetLength(i));
        }
        double d3 = this.getBounds().getCenterY();
        double d4 = this.getBounds().getCenterX();
        double d5 = Math.min(d2 * 0.9, d * 0.9);
        double d6 = 0.0;
        for (n = n3; n >= 1 && !this.getStopFlag(); --n) {
            int n4;
            double d7 = d5 / (double)n3 * (double)n;
            Ellipse2D.Double double_ = new Ellipse2D.Double(d4 - d7 / 2.0, d3 - d7 / 2.0, d7, d7);
            double d8 = 0.0;
            double d9 = 0.0;
            for (n4 = 0; n4 < n2 && !this.getStopFlag(); ++n4) {
                d6 = chartDataModel.getValueAt(n4, n - 1).doubleValue();
                if (Double.isNaN(d6)) continue;
                d8 += d6;
            }
            for (n4 = 0; n4 < n2 && !this.getStopFlag(); ++n4) {
                double d10 = chartDataModel.getValueAt(n4, n - 1).doubleValue();
                if (Double.isNaN(d10)) {
                    d10 = 0.0;
                }
                Arc2D.Double double_2 = new Arc2D.Double(double_.getBounds2D(), d9, 360.0 * d10 / d8, 2);
                d9 += 360.0 * d10 / d8;
                graphics2D.setColor(rowColorModel.getColor(n4));
                graphics2D.fill(double_2);
            }
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        n = !this.getStopFlag() ? 1 : 0;
        this.resetStopFlag();
        return n != 0;
    }
}

