/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class PlotChartRenderer
extends AbstractChartRenderer {
    protected double shapeSize = 10.0;

    public PlotChartRenderer(CoordSystem coordSystem, ChartDataModel chartDataModel) {
        super(coordSystem, chartDataModel);
    }

    public boolean renderChart(Graphics2D graphics2D) {
        int n;
        ChartDataModel chartDataModel = this.getChartDataModel();
        RowColorModel rowColorModel = this.getRowColorModel();
        AffineTransform affineTransform = this.getTransform(0);
        int n2 = chartDataModel.getDataSetNumber();
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        boolean bl = chartDataModel.isColumnNumeric();
        float f = 0.0f;
        for (n = 0; n < n2 && !this.getStopFlag(); ++n) {
            for (int i = 0; i < chartDataModel.getDataSetLength(n) && !this.getStopFlag(); ++i) {
                f = chartDataModel.getValueAt(n, i).floatValue();
                if (f != f) continue;
                Point2D.Float float_2 = bl ? new Point2D.Float(((Number)chartDataModel.getColumnValueAt(n, i)).floatValue(), f) : new Point2D.Float(i, f);
                affineTransform.transform(float_2, float_);
                if (float_ == null) continue;
                graphics2D.setColor(rowColorModel.getColor(n));
                RectangularShape rectangularShape = rowColorModel.getShape(n);
                rectangularShape.setFrame(((Point2D)float_).getX() - this.shapeSize / 2.0, ((Point2D)float_).getY() - this.shapeSize / 2.0, this.shapeSize, this.shapeSize);
                graphics2D.fill(rectangularShape);
            }
        }
        n = !this.getStopFlag() ? 1 : 0;
        this.resetStopFlag();
        return n != 0;
    }
}

