/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystemUtilities;
import com.approximatrix.charting.coordsystem.ticklocator.NumericTickLocator;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.Serializable;

public class RadarChartRenderer
extends AbstractChartRenderer {
    private static final int LABEL_BUFFER = 3;
    private static final float[] DOT1 = new float[]{1.0f};
    protected Stroke gridStroke = new BasicStroke(1.0f, 0, 0, 10.0f, DOT1, 0.0f);
    protected Color gridColor = Color.lightGray;
    protected int estimated_grid_steps = 10;
    private boolean drawGrid = true;

    public RadarChartRenderer(ChartDataModel chartDataModel) {
        super(chartDataModel);
    }

    public RadarChartRenderer(CoordSystem coordSystem, ChartDataModel chartDataModel) {
        super(coordSystem, chartDataModel);
    }

    public boolean renderChart(Graphics2D graphics2D) {
        int n;
        Serializable serializable;
        double d;
        double d2;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartDataModel chartDataModel = this.getChartDataModel();
        RowColorModel rowColorModel = this.getRowColorModel();
        double d3 = this.getBounds().getHeight();
        double d4 = this.getBounds().getWidth();
        int n2 = chartDataModel.getDataSetNumber();
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < n2; ++i) {
            n3 = Math.min(n3, chartDataModel.getDataSetLength(i));
        }
        double[] dArray = new double[n3];
        double d5 = this.getBounds().getCenterY();
        double d6 = this.getBounds().getCenterX();
        double d7 = Math.min(d4 * 0.9, d3 * 0.9) / 2.0;
        double[] dArray2 = null;
        double[] dArray3 = this.getScaling();
        double d8 = 0.0;
        if (dArray3 != null && dArray3[0] > 0.0) {
            dArray2 = new NumericTickLocator(dArray3[0], 0.0, this.estimated_grid_steps, this.coord.getMaximumYTicks()).getTickMarkLocations();
            d8 = 1.1 * dArray3[0];
        }
        for (int i = 0; i < n2 && !this.getStopFlag(); ++i) {
            GeneralPath generalPath = new GeneralPath(0, n3);
            for (int j = 0; j < n3 && !this.getStopFlag(); ++j) {
                double d9 = chartDataModel.getValueAt(i, j).doubleValue();
                if (d8 == 0.0) {
                    for (int k = 0; k < n2; ++k) {
                        d8 = Math.max(d8, chartDataModel.getValueAt(k, j).doubleValue() * 1.1);
                    }
                    dArray[j] = d8;
                }
                double d10 = d9 / d8;
                double d11 = d7 * d10;
                double d12 = -1.0 * (Math.PI * 2 / (double)n3) * (double)j + Math.PI;
                d2 = d6 + d11 * Math.sin(d12);
                d = d5 + d11 * Math.cos(d12);
                Line2D.Double double_ = new Line2D.Double(d6, d5, d2, d);
                graphics2D.setColor(Color.black);
                graphics2D.draw(double_);
                if (j == 0) {
                    generalPath.moveTo((float)d2, (float)d);
                    continue;
                }
                generalPath.lineTo((float)d2, (float)d);
            }
            generalPath.closePath();
            graphics2D.setPaint(rowColorModel.getColor(i));
            graphics2D.draw(generalPath);
        }
        if (dArray2 != null && d8 > 0.0 && this.isDrawGrid()) {
            Stroke stroke = graphics2D.getStroke();
            serializable = graphics2D.getColor();
            graphics2D.setStroke(this.gridStroke);
            graphics2D.setColor(this.gridColor);
            for (int i = 0; i < dArray2.length && !this.getStopFlag(); ++i) {
                GeneralPath generalPath = new GeneralPath(0, n3);
                if (dArray2[i] > d8 || dArray2[i] == 0.0) continue;
                d2 = dArray2[i] / d8;
                d = d7 * d2;
                for (int j = 0; j < n3 && !this.getStopFlag(); ++j) {
                    double d13 = -1.0 * (Math.PI * 2 / (double)n3) * (double)j + Math.PI;
                    double d14 = d6 + d * Math.sin(d13);
                    double d15 = d5 + d * Math.cos(d13);
                    if (j == 0) {
                        generalPath.moveTo((float)d14, (float)d15);
                        TextLayout textLayout = new TextLayout(this.coord.getYDecimalFormat().format(dArray2[i]), this.coord.getTickFont(), new FontRenderContext(null, true, false));
                        graphics2D.setStroke(stroke);
                        graphics2D.setColor(Color.black);
                        textLayout.draw(graphics2D, (float)d14 + 3.0f, (float)d15);
                        graphics2D.setStroke(this.gridStroke);
                        graphics2D.setColor(this.gridColor);
                        continue;
                    }
                    generalPath.lineTo((float)d14, (float)d15);
                }
                generalPath.closePath();
                graphics2D.draw(generalPath);
            }
            graphics2D.setStroke(stroke);
            graphics2D.setColor((Color)serializable);
        }
        for (n = 0; n < n3 && !this.getStopFlag(); ++n) {
            double d16 = -1.0 * (Math.PI * 2 / (double)n3) * (double)n + Math.PI;
            double d17 = d6 + d7 * Math.sin(d16);
            double d18 = d5 + d7 * Math.cos(d16);
            serializable = new Line2D.Double(d6, d5, d17, d18);
            graphics2D.setColor(Color.black);
            graphics2D.draw((Shape)((Object)serializable));
            TextLayout textLayout = new TextLayout("" + this.model.getColumnValueAt(n), new Font("Courier", 1, 9), new FontRenderContext(null, true, false));
            graphics2D.setColor(Color.black);
            if (d16 <= 1.5707963267948966 && d16 >= -1.5707963267948966) {
                d18 += textLayout.getBounds().getHeight();
            }
            if (d16 <= 0.0) {
                d17 -= textLayout.getBounds().getWidth();
            }
            textLayout.draw(graphics2D, (float)d17, (float)d18);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        n = !this.getStopFlag() ? 1 : 0;
        this.resetStopFlag();
        return n != 0;
    }

    private double[] getScaling() {
        try {
            return CoordSystemUtilities.SafeMaxMin(this.model.getChartDataModelConstraints(0).getMaximumY().doubleValue(), this.model.getChartDataModelConstraints(0).getMinimumY().doubleValue());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void setDrawGrid(boolean bl) {
        this.drawGrid = bl;
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }
}

