/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.shape.Diamond2D;
import com.approximatrix.charting.render.shape.Triangle2D;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;

public class RowColorModel {
    private static RowColorModel instance;
    protected ChartDataModel model;
    protected static final Color[] predefinedColors;
    public static final Ellipse2D ELLIPSE_SHAPE;
    public static final Rectangle2D SQUARE_SHAPE;
    public static final Diamond2D DIAMOND_SHAPE;
    public static final Triangle2D TRIANGLE_SHAPE;
    public static final Triangle2D TRIANGLEDOWN_SHAPE;
    protected static final RectangularShape[] predefinedShapes;
    protected int predefinedColorsIdx = 0;
    protected HashMap customColors = new HashMap();
    protected HashMap customShapes = new HashMap();

    public RowColorModel(ChartDataModel chartDataModel) {
        this.model = chartDataModel;
    }

    public static RowColorModel getInstance(ChartDataModel chartDataModel) {
        if (instance == null || !chartDataModel.equals(RowColorModel.instance.model)) {
            instance = new RowColorModel(chartDataModel);
        }
        return instance;
    }

    public int getRowCount() {
        return this.model.getDataSetNumber();
    }

    public String getRow(int n) {
        return this.model.getDataSetName(n);
    }

    public Color getColor(int n) {
        Color color = (Color)this.customColors.get(new Integer(n));
        if (color == null) {
            color = this.predefinedColorsIdx < predefinedColors.length ? predefinedColors[this.predefinedColorsIdx++] : new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            this.customColors.put(new Integer(n), color);
        }
        return color;
    }

    public RectangularShape getShape(int n) {
        RectangularShape rectangularShape = (RectangularShape)this.customShapes.get(new Integer(n));
        if (rectangularShape == null) {
            rectangularShape = predefinedShapes[n % predefinedShapes.length];
            this.customShapes.put(new Integer(n), rectangularShape);
        }
        return rectangularShape;
    }

    public void setColor(int n, Color color) {
        this.customColors.put(new Integer(n), color);
    }

    public void setShape(int n, RectangularShape rectangularShape) {
        this.customShapes.put(new Integer(n), rectangularShape);
    }

    static {
        predefinedColors = new Color[]{Color.blue, Color.cyan, Color.red, Color.pink, Color.yellow, Color.green, Color.magenta, Color.orange, Color.darkGray, Color.gray, Color.lightGray};
        ELLIPSE_SHAPE = new Ellipse2D.Float(0.0f, 0.0f, 5.0f, 5.0f);
        SQUARE_SHAPE = new Rectangle2D.Float(0.0f, 0.0f, 5.0f, 5.0f);
        DIAMOND_SHAPE = new Diamond2D(0.0, 0.0, 5.0, 5.0);
        TRIANGLE_SHAPE = new Triangle2D(0.0, 0.0, 5.0, 5.0, false);
        TRIANGLEDOWN_SHAPE = new Triangle2D(0.0, 0.0, 5.0, 5.0, true);
        predefinedShapes = new RectangularShape[]{ELLIPSE_SHAPE, SQUARE_SHAPE, DIAMOND_SHAPE, TRIANGLE_SHAPE, TRIANGLEDOWN_SHAPE};
    }
}

