/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ScatterDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class ScatterChartRenderer
extends AbstractChartRenderer {
    protected double shapeSize = 10.0;

    public ScatterChartRenderer(CoordSystem coordSystem, ChartDataModel chartDataModel) {
        super(coordSystem, chartDataModel);
    }

    public boolean renderChart(Graphics2D graphics2D) {
        int n;
        ScatterDataModel scatterDataModel = (ScatterDataModel)this.getChartDataModel();
        RowColorModel rowColorModel = this.getRowColorModel();
        AffineTransform affineTransform = this.getTransform(0);
        int n2 = scatterDataModel.getDataSetNumber();
        for (n = 0; n < n2 && !this.getStopFlag(); ++n) {
            if (scatterDataModel.getSeriesLine(n)) {
                this.drawline(scatterDataModel, rowColorModel, affineTransform, n, graphics2D);
            }
            if (!scatterDataModel.getSeriesMarker(n)) continue;
            this.drawmarkers(scatterDataModel, rowColorModel, affineTransform, n, graphics2D);
        }
        n = !this.getStopFlag() ? 1 : 0;
        this.resetStopFlag();
        return n != 0;
    }

    private void drawline(ScatterDataModel scatterDataModel, RowColorModel rowColorModel, AffineTransform affineTransform, int n, Graphics2D graphics2D) {
        Point2D point2D = null;
        Point2D point2D2 = null;
        boolean bl = scatterDataModel.isColumnNumeric();
        float f = 0.0f;
        for (int i = 0; i < scatterDataModel.getDataSetLength(n); ++i) {
            f = scatterDataModel.getValueAt(n, i).floatValue();
            if (f != f || f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY) {
                point2D2 = null;
                continue;
            }
            Point2D.Float float_ = bl ? new Point2D.Float(((Number)scatterDataModel.getColumnValueAt(n, i)).floatValue(), f) : new Point2D.Float(i, f);
            point2D2 = point2D;
            if (affineTransform.transform(float_, null) == null) continue;
            point2D = affineTransform.transform(float_, null);
            graphics2D.setColor(rowColorModel.getColor(n));
            if (point2D2 == null) continue;
            graphics2D.drawLine((int)point2D2.getX(), (int)point2D2.getY(), (int)point2D.getX(), (int)point2D.getY());
        }
    }

    private void drawmarkers(ScatterDataModel scatterDataModel, RowColorModel rowColorModel, AffineTransform affineTransform, int n, Graphics2D graphics2D) {
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        boolean bl = scatterDataModel.isColumnNumeric();
        float f = 0.0f;
        for (int i = 0; i < scatterDataModel.getDataSetLength(n); ++i) {
            f = scatterDataModel.getValueAt(n, i).floatValue();
            if (f != f) continue;
            Point2D.Float float_2 = bl ? new Point2D.Float(((Number)scatterDataModel.getColumnValueAt(n, i)).floatValue(), f) : new Point2D.Float(i, f);
            affineTransform.transform(float_2, float_);
            if (float_ == null) continue;
            graphics2D.setColor(rowColorModel.getColor(n));
            RectangularShape rectangularShape = rowColorModel.getShape(n);
            rectangularShape.setFrame(((Point2D)float_).getX() - this.shapeSize / 2.0, ((Point2D)float_).getY() - this.shapeSize / 2.0, this.shapeSize, this.shapeSize);
            graphics2D.fill(rectangularShape);
        }
    }
}

