/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class StackedBarChartRenderer
extends AbstractChartRenderer {
    protected float boxWidth = 1.0f;

    public StackedBarChartRenderer(CoordSystem coordSystem, AbstractChartDataModel abstractChartDataModel) {
        super(coordSystem, abstractChartDataModel);
    }

    public StackedBarChartRenderer(CoordSystem coordSystem, AbstractChartDataModel abstractChartDataModel, float f) {
        this(coordSystem, abstractChartDataModel);
        this.boxWidth = f;
    }

    public boolean renderChart(Graphics2D graphics2D) {
        int n;
        ChartDataModel chartDataModel = this.getChartDataModel();
        ChartDataModelConstraints chartDataModelConstraints = chartDataModel.getChartDataModelConstraints(0);
        System.out.println("** Maximum: " + chartDataModelConstraints.getMaximumValue() + " Minimum: " + chartDataModelConstraints.getMinimumValue());
        if (chartDataModel.isColumnNumeric()) {
            return false;
        }
        RowColorModel rowColorModel = this.getRowColorModel();
        AffineTransform affineTransform = this.getTransform(0);
        int n2 = chartDataModel.getDataSetNumber();
        int n3 = Integer.MIN_VALUE;
        for (int i = 0; i < this.model.getDataSetNumber(); ++i) {
            n3 = Math.max(n3, this.model.getDataSetLength(i));
        }
        Point2D point2D = chartDataModelConstraints.getMinimumValue().floatValue() > 0.0f ? affineTransform.transform(new Point2D.Float((float)chartDataModelConstraints.getMinimumColumnValue(), chartDataModelConstraints.getMinimumValue().floatValue()), null) : (chartDataModelConstraints.getMaximumValue().floatValue() < 0.0f ? affineTransform.transform(new Point2D.Float((float)chartDataModelConstraints.getMinimumColumnValue(), chartDataModelConstraints.getMaximumValue().floatValue()), null) : affineTransform.transform(new Point2D.Float((float)chartDataModelConstraints.getMinimumColumnValue(), 0.0f), null));
        Point2D point2D2 = affineTransform.transform(new Point2D.Float((float)chartDataModelConstraints.getMinimumColumnValue(), chartDataModelConstraints.getMaximumValue().floatValue()), null);
        Point2D point2D3 = affineTransform.transform(new Point2D.Float((float)chartDataModelConstraints.getMaximumColumnValue(), chartDataModelConstraints.getMaximumValue().floatValue()), null);
        Point2D point2D4 = point2D2;
        int n4 = (int)((point2D3.getX() - point2D2.getX()) / chartDataModelConstraints.getMaximumColumnValue());
        int n5 = (int)((float)n4 * this.boxWidth);
        float f = (float)((double)n4 * ((1.0 - (double)this.boxWidth) / 2.0));
        double d = 0.0;
        Rectangle2D.Float float_ = null;
        for (n = 0; n < n3 && !this.getStopFlag(); ++n) {
            double d2 = 0.0;
            double d3 = 0.0;
            Point2D point2D5 = point2D;
            Point2D point2D6 = point2D;
            for (int i = 0; i < chartDataModel.getDataSetNumber() && !this.getStopFlag(); ++i) {
                d = n < chartDataModel.getDataSetLength(i) ? chartDataModel.getValueAt(i, n).doubleValue() : 0.0;
                if (d < 0.0) {
                    affineTransform.transform(new Point2D.Float(n, (float)(d2 += d)), point2D4);
                    float_ = new Rectangle2D.Float((float)point2D4.getX(), (float)Math.min(point2D4.getY(), point2D6.getY()), n5, (float)Math.abs(point2D6.getY() - point2D4.getY()));
                    point2D6 = (Point2D)point2D4.clone();
                } else {
                    affineTransform.transform(new Point2D.Float(n, (float)(d3 += d)), point2D4);
                    float_ = new Rectangle2D.Float((float)point2D4.getX(), (float)Math.min(point2D4.getY(), point2D5.getY()), n5, (float)Math.abs(point2D5.getY() - point2D4.getY()));
                    point2D5 = (Point2D)point2D4.clone();
                }
                graphics2D.setColor(rowColorModel.getColor(i));
                graphics2D.fill(float_);
                graphics2D.setColor(Color.black);
                graphics2D.draw(float_);
            }
        }
        n = !this.getStopFlag() ? 1 : 0;
        this.resetStopFlag();
        return n != 0;
    }
}

