/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.AbstractChart;
import com.approximatrix.charting.Chart;
import com.approximatrix.charting.Legend;
import com.approximatrix.charting.Title;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Map;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChartPanel
extends JPanel
implements Chart,
MouseMotionListener,
MouseListener,
Printable {
    public static final int PAGE_EXISTS = 0;
    public static final int NO_SUCH_PAGE = 1;
    protected AbstractChart chart;

    public AbstractChartPanel() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void addChartRenderer(AbstractChartRenderer abstractChartRenderer, int n) {
        this.chart.addChartRenderer(abstractChartRenderer, n);
    }

    @Override
    public Rectangle getBounds() {
        return this.chart.getBounds();
    }

    @Override
    public ChartDataModel getChartDataModel() {
        return this.chart.getChartDataModel();
    }

    @Override
    public Map<Integer, AbstractChartRenderer> getChartRenderer() {
        return this.chart.getChartRenderer();
    }

    @Override
    public AbstractChartRenderer getChartRenderer(int n) {
        return this.chart.getChartRenderer(n);
    }

    @Override
    public CoordSystem getCoordSystem() {
        return this.chart.getCoordSystem();
    }

    @Override
    public Legend getLegend() {
        return this.chart.getLegend();
    }

    @Override
    public Title getTitle() {
        return this.chart.getTitle();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.chart.setBounds(rectangle);
    }

    @Override
    public void setChartDataModel(ChartDataModel chartDataModel) {
        this.chart.setChartDataModel(chartDataModel);
    }

    public void setChartRenderer(Map map) {
        this.chart.setChartRenderer(map);
    }

    @Override
    public void setCoordSystem(CoordSystem coordSystem) {
        this.chart.setCoordSystem(coordSystem);
    }

    @Override
    public void setLegend(Legend legend) {
        this.chart.setLegend(legend);
    }

    @Override
    public void setTitle(Title title) {
        this.chart.setTitle(title);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void paint(Graphics graphics) {
        this.chart.setBounds(new Rectangle(this.getWidth(), this.getHeight()));
        this.chart.render((Graphics2D)graphics);
    }

    @Override
    public void render(Graphics2D graphics2D) {
        this.paint(graphics2D);
    }

    public void setRowColorModel(RowColorModel rowColorModel) throws NullPointerException {
        this.chart.setRowColorModel(rowColorModel);
    }

    public RowColorModel getRowColorModel() {
        return this.chart.getRowColorModel();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = (int)pageFormat.getImageableX();
        int n3 = (int)pageFormat.getImageableY();
        graphics.translate(n2, n3);
        if (n == 0) {
            this.paint(graphics);
            return 0;
        }
        return 1;
    }
}

