/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.BufferedChart;
import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.swing.AbstractChartPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;

public class BufferedChartPanel
extends AbstractChartPanel
implements RenderChangeListener {
    private Rectangle currentRect = null;
    private Rectangle grRect = null;

    private BufferedChartPanel() {
    }

    public BufferedChartPanel(ChartDataModel chartDataModel, String string) {
        this();
        this.chart = new BufferedChart(chartDataModel, string);
        this.chart.addRenderChangeListener(this);
    }

    public BufferedChartPanel(ChartDataModel chartDataModel, String string, int n) {
        this();
        this.chart = new BufferedChart(chartDataModel, string, n);
        this.chart.addRenderChangeListener(this);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.currentRect != null) {
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.grRect.x, this.grRect.y, this.grRect.width - 1, this.grRect.height - 1);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateSize(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.currentRect = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
        this.updateSize(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateSize(mouseEvent);
        this.currentRect = null;
        this.repaint();
    }

    private void updateSize(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.currentRect.x;
        int n2 = mouseEvent.getY() - this.currentRect.y;
        this.currentRect.setSize(n, n2);
        if (this.currentRect.width < 0 || this.currentRect.height < 0 || this.grRect == null) {
            this.grRect = new Rectangle(Math.min(this.currentRect.x, this.currentRect.x + n), Math.min(this.currentRect.y, this.currentRect.y + n2), Math.abs(n), Math.abs(n2));
        } else {
            this.grRect.setSize(n, n2);
        }
        this.repaint();
    }

    public void renderUpdateRequested(RenderChangeEvent renderChangeEvent) {
        this.repaint();
    }

    public boolean isBuffering() {
        return ((BufferedChart)this.chart).isBuffering();
    }

    public void setBuffering(boolean bl) {
        ((BufferedChart)this.chart).setBuffering(bl);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        boolean bl = this.isBuffering();
        this.setBuffering(false);
        int n2 = super.print(graphics, pageFormat, n);
        this.setBuffering(bl);
        return n2;
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }
}

