/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.DefaultChart;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.swing.AbstractChartPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class ChartPanel
extends AbstractChartPanel {
    private Rectangle currentRect = null;
    private Rectangle grRect = null;

    private ChartPanel() {
    }

    public ChartPanel(ChartDataModel chartDataModel, String string) {
        this();
        this.chart = new DefaultChart(chartDataModel, string);
    }

    public ChartPanel(ChartDataModel chartDataModel, String string, int n) {
        this();
        this.chart = new DefaultChart(chartDataModel, string, n);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.currentRect != null) {
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.grRect.x, this.grRect.y, this.grRect.width - 1, this.grRect.height - 1);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateSize(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.currentRect = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
        this.updateSize(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateSize(mouseEvent);
        this.currentRect = null;
        this.repaint();
    }

    private void updateSize(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.currentRect.x;
        int n2 = mouseEvent.getY() - this.currentRect.y;
        this.currentRect.setSize(n, n2);
        if (this.currentRect.width < 0 || this.currentRect.height < 0 || this.grRect == null) {
            this.grRect = new Rectangle(Math.min(this.currentRect.x, this.currentRect.x + n), Math.min(this.currentRect.y, this.currentRect.y + n2), Math.abs(n), Math.abs(n2));
        } else {
            this.grRect.setSize(n, n2);
        }
        this.repaint();
    }
}

