/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.ExtendedChart;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.swing.AbstractChartPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;

public class ExtendedChartPanel
extends AbstractChartPanel {
    private boolean zoom_enabled = false;
    private int zoom_button = 1;
    private int autoscale_button = 3;
    private Rectangle currentRect = null;
    private Rectangle grRect = null;

    private ExtendedChartPanel() {
    }

    public ExtendedChartPanel(ChartDataModel chartDataModel, String string) {
        this();
        this.chart = new ExtendedChart(chartDataModel, string);
    }

    public ExtendedChartPanel(ChartDataModel chartDataModel, String string, int n) {
        this();
        this.chart = new ExtendedChart(chartDataModel, string, n);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.currentRect != null) {
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.grRect.x, this.grRect.y, this.grRect.width - 1, this.grRect.height - 1);
        }
    }

    public void render(Graphics2D graphics2D) {
        this.paint(graphics2D);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.zoom_enabled) {
            return;
        }
        this.updateSize(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.zoom_enabled) {
            return;
        }
        if (mouseEvent.getButton() == this.zoom_button) {
            this.currentRect = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
            this.grRect = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.zoom_enabled) {
            return;
        }
        if (mouseEvent.getButton() == this.zoom_button) {
            this.updateSize(mouseEvent);
            if (this.chart instanceof ExtendedChart) {
                ExtendedChart extendedChart = (ExtendedChart)this.chart;
                extendedChart.getChartDataModel().setAutoScale(false);
                extendedChart.getChartDataModel().setManualScale(true);
                extendedChart.zoom(this.grRect);
            }
            this.currentRect = null;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.zoom_enabled) {
            return;
        }
        if (mouseEvent.getButton() == this.autoscale_button) {
            this.performAutoScale();
        }
    }

    public void performAutoScale() {
        this.chart.getChartDataModel().setAutoScale(true);
        this.chart.getChartDataModel().setManualScale(false);
        this.chart.getChartDataModel().fireChartDataModelChangedEvent(this);
        this.repaint();
    }

    public void enableZoom(boolean bl) {
        this.zoom_enabled = bl;
    }

    public boolean isEnableZoom() {
        return this.zoom_enabled;
    }

    public void setAutoscaleMouseButton(int n) {
        this.autoscale_button = n;
    }

    public void setZoomMouseButton(int n) {
        this.zoom_button = n;
    }

    private void updateSize(MouseEvent mouseEvent) {
        if (this.currentRect == null || !this.zoom_enabled) {
            return;
        }
        int n = mouseEvent.getX() - this.currentRect.x;
        int n2 = mouseEvent.getY() - this.currentRect.y;
        this.currentRect.setSize(n, n2);
        if (this.currentRect.width < 0 || this.currentRect.height < 0 || this.grRect == null) {
            this.grRect = new Rectangle(Math.min(this.currentRect.x, this.currentRect.x + n), Math.min(this.currentRect.y, this.currentRect.y + n2), Math.abs(n), Math.abs(n2));
        } else {
            this.grRect.setSize(n, n2);
        }
        this.repaint();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = (int)pageFormat.getImageableX();
        int n3 = (int)pageFormat.getImageableY();
        this.chart.setBounds(new Rectangle(0, 0, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight()));
        graphics.translate(n2, n3);
        if (n == 0) {
            this.paint(graphics);
            this.repaint();
            return 0;
        }
        this.repaint();
        return 1;
    }
}

