/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.event.InfoAvailableEvent;
import com.approximatrix.charting.event.InfoAvailableListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.swing.ExtendedChartPanel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public abstract class InteractiveChartPanel
extends ExtendedChartPanel
implements ActionListener {
    protected EventListenerList listener = new EventListenerList();
    private final int WAIT_FOR_TIP = 500;
    protected Timer moveTimer = null;
    protected Point mp = null;

    public InteractiveChartPanel(ChartDataModel chartDataModel, String string, int n) {
        super(chartDataModel, string, n);
        this.initialize();
    }

    public InteractiveChartPanel(ChartDataModel chartDataModel, String string) {
        super(chartDataModel, string);
        this.initialize();
    }

    private void initialize() {
        this.moveTimer = new Timer(500, this);
        this.moveTimer.setRepeats(false);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.moveTimer.stop();
        if (this.getCoordSystem().getInnerBounds().contains(mouseEvent.getPoint())) {
            this.mp = mouseEvent.getPoint();
            this.moveTimer.start();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mp == null) {
            return;
        }
        Point point = new Point(this.getLocationOnScreen());
        point.translate(this.mp.x, this.mp.y);
        Point point2 = new Point();
        try {
            this.getCoordSystem().getDefaultTransform(0).createInverse().transform(this.mp, point2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            System.err.println("Inverse graphics- to data-space transform failed");
            return;
        }
        this.fireInfoAvailable(this, point2);
    }

    public void fireInfoAvailable(Object object, Point point) {
        InfoAvailableEvent infoAvailableEvent = new InfoAvailableEvent(object, point);
        Object[] objectArray = this.listener.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InfoAvailableListener.class) continue;
            ((InfoAvailableListener)objectArray[i + 1]).onInformationAvailable(infoAvailableEvent);
        }
    }

    public void removeInfoAvailableListener(InfoAvailableListener infoAvailableListener) {
        this.listener.remove(InfoAvailableListener.class, infoAvailableListener);
    }

    public void addInfoAvailableListener(InfoAvailableListener infoAvailableListener) {
        Object[] objectArray = this.listener.getListenerList();
        boolean bl = false;
        for (int i = objectArray.length - 1; i >= 1; i -= 2) {
            if (objectArray[i] != infoAvailableListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.listener.add(InfoAvailableListener.class, infoAvailableListener);
        }
    }

    public void clearInfoAvailableListener() {
        this.listener = new EventListenerList();
    }
}

