/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.test;

import com.approximatrix.charting.ChartEncoder;
import com.approximatrix.charting.DefaultChart;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ScatterDataModel;
import com.approximatrix.charting.render.ScatterChartRenderer;
import com.approximatrix.charting.swing.ExtendedChartPanel;
import com.approximatrix.charting.test.ImageFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class GraphFrame
extends JFrame
implements ActionListener,
ChartDataModelListener {
    ExtendedChartPanel panel;
    ScatterDataModel data;
    Timer t = new Timer(1000, this);
    double time = 3.0;
    private JPopupMenu jPopupMenu1;
    private JMenuItem jMenuItem1;

    public GraphFrame() {
        double[][] dArrayArray = new double[][]{{25.0, 22.0, 23.0}, {13.0, 11.0, 12.0}};
        double[] dArray = new double[]{0.0, 1.0, 2.0};
        String[] stringArray = new String[]{"1998", "1999", "2000"};
        String[] stringArray2 = new String[]{"Int. Temp.", "Ext. Temp."};
        String string = "Viewing Internal & External Temperature";
        this.data = new ScatterDataModel(dArrayArray, dArray, stringArray2);
        this.panel = new ExtendedChartPanel(this.data, string, DefaultChart.LINEAR_X_LINEAR_Y);
        this.panel.addChartRenderer(new ScatterChartRenderer(this.panel.getCoordSystem(), this.data), 1);
        this.data.addChartDataModelListener(this);
        this.panel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    GraphFrame.this.jPopupMenu1.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.initComponents();
        this.setSize(640, 480);
        this.getContentPane().add((Component)this.panel, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.data.insertValue(0, new Double(Math.random() * 10.0 + 20.0), new Double(this.time));
        this.data.insertValue(1, new Double(Math.random() * 7.0 + 10.0), new Double(this.time));
        this.time += 1.0;
    }

    public void chartDataChanged(ChartDataModelEvent chartDataModelEvent) {
        this.panel.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem1.setText("Export Image File ...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.jMenuItemExportActionPerformed(actionEvent);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem1.setText("Print Graph ...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.jMenuItemPrintActionPerformed(actionEvent);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphFrame.this.exitForm(windowEvent);
            }
        });
        this.pack();
    }

    private void jMenuItemExportActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
        jFileChooser.setFileFilter(new ImageFilter(ChartEncoder.getSupportedFormats()));
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string = file.getPath();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        System.out.println("** filename = " + string + " fileending = " + string2);
        boolean bl = false;
        String[] stringArray = ChartEncoder.getSupportedFormats();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equalsIgnoreCase(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            string2 = "png";
            string = string.substring(0, string.lastIndexOf(46)) + "." + string2;
            System.out.println("** filename = " + string + " fileending = " + string2);
            file = new File(string);
        }
        try {
            ChartEncoder.createEncodedImage(new FileOutputStream(file), this.panel, string2);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Fehler beim Speichern", 0);
            System.out.println("** Error creating the nevilletest.png file, showing the Neville Interpolation.");
            exception.printStackTrace();
            return;
        }
    }

    private void jMenuItemPrintActionPerformed(ActionEvent actionEvent) {
        block2: {
            System.out.println("Printing attempted!");
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, hashPrintRequestAttributeSet);
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            PrintService printService2 = ServiceUI.printDialog(null, 200, 200, printServiceArray, printService, sERVICE_FORMATTED, hashPrintRequestAttributeSet);
            if (printService2 == null) break block2;
            DocPrintJob docPrintJob = printService2.createPrintJob();
            HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
            SimpleDoc simpleDoc = new SimpleDoc(this.panel, sERVICE_FORMATTED, hashDocAttributeSet);
            try {
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
            }
            catch (PrintException printException) {
                System.err.println("Failed!");
            }
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        new GraphFrame().show();
    }
}

